/*
 * Decompiled with CFR 0.152.
 */
package org.appops.web.jetty.client;

import java.io.File;
import java.nio.file.Paths;
import org.appops.web.common.client.MultiPartData;
import org.appops.web.common.client.WebClientException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;

public class ContentProviderCreator {
    ContentProvider create(Object content) {
        if (content == null) {
            throw new WebClientException("Cannot create ContentProvider for null content.");
        }
        try {
            if (content instanceof String) {
                return new StringContentProvider((String)content);
            }
            if (content instanceof File) {
                return new PathContentProvider(Paths.get(((File)content).getPath(), new String[0]));
            }
            if (content instanceof MultiPartData) {
                return this.createMultipartContentProvider((MultiPartData)content);
            }
            throw new WebClientException("Content type -> " + content.getClass().getSimpleName() + " not supported yet.");
        }
        catch (Exception e) {
            throw new WebClientException((Throwable)e);
        }
    }

    private MultiPartContentProvider createMultipartContentProvider(MultiPartData multipartData) {
        MultiPartContentProvider mulipartContentProvider = new MultiPartContentProvider();
        for (String fieldName : multipartData.fieldNames()) {
            Object value = multipartData.getField(fieldName);
            ContentProvider contentProvider = this.create(value);
            if (value instanceof File) {
                mulipartContentProvider.addFilePart(fieldName, ((File)value).getName(), contentProvider, null);
                continue;
            }
            mulipartContentProvider.addFieldPart(fieldName, contentProvider, null);
        }
        return mulipartContentProvider;
    }
}

