/*
 * Decompiled with CFR 0.152.
 */
package org.appops.web.jetty.client;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.appops.core.mime.MimeType;
import org.appops.web.common.client.Cookie;
import org.appops.web.common.client.HttpHeader;
import org.appops.web.common.client.Proxy;
import org.appops.web.common.client.ServerResponse;
import org.appops.web.common.client.WebClient;
import org.appops.web.common.client.WebClientException;
import org.appops.web.jetty.client.ContentProviderCreator;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyWebClient
extends WebClient<HttpClient> {
    public JettyWebClient() {
        this.setWrappedClient(JettyWebClient.createHttpClient());
    }

    private static HttpClient createHttpClient() {
        SslContextFactory.Client ssl = new SslContextFactory.Client();
        ssl.setEndpointIdentificationAlgorithm("HTTPS");
        HttpClient http = new HttpClient((SslContextFactory)ssl);
        return http;
    }

    public ServerResponse get(String url) {
        return this.get(url, null, null, null, null);
    }

    private void configureHeaderInRequest(Request request, HttpHeader header) {
        HashMap headerMap = header.getHeaderMap();
        for (Map.Entry entry : headerMap.entrySet()) {
            request.header((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public ServerResponse get(String url, Object content, MimeType mimeType, Cookie cookie, HttpHeader header) {
        try {
            this.start();
            Request request = ((HttpClient)this.wrappedClient()).newRequest(url);
            request.method(HttpMethod.GET);
            if (cookie != null) {
                request.cookie(this.createHttpCookie(cookie));
            }
            if (content != null && mimeType != null) {
                String contentType = (String)((Object)mimeType.value());
                ContentProvider contentProvider = new ContentProviderCreator().create(content);
                if (contentProvider instanceof MultiPartContentProvider) {
                    contentType = ((MultiPartContentProvider)contentProvider).getContentType();
                }
                request.content(contentProvider, contentType);
            }
            if (header != null && header.getHeaderMap() != null && !header.getHeaderMap().isEmpty()) {
                this.configureHeaderInRequest(request, header);
            }
            FutureResponseListener listener = new FutureResponseListener(request, 30485760);
            request.send((Response.CompleteListener)listener);
            ContentResponse contentResponse = listener.get();
            ServerResponse serverResponse = this.convertToServerResponse(contentResponse);
            return serverResponse;
        }
        catch (Exception e) {
            throw new WebClientException((Throwable)e);
        }
        finally {
            this.stop();
        }
    }

    public ServerResponse post(String url, Object content, MimeType contentType) {
        return this.post(url, content, contentType, null, null);
    }

    public ServerResponse post(String url, Object content, MimeType mimeType, Cookie cookie, HttpHeader header) {
        try {
            this.start();
            Request request = ((HttpClient)this.wrappedClient()).POST(url);
            if (cookie != null) {
                request.cookie(this.createHttpCookie(cookie));
            }
            if (content != null && mimeType != null) {
                String contentType = (String)((Object)mimeType.value());
                ContentProvider contentProvider = new ContentProviderCreator().create(content);
                if (contentProvider instanceof MultiPartContentProvider) {
                    contentType = ((MultiPartContentProvider)contentProvider).getContentType();
                }
                request.content(contentProvider, contentType);
            }
            if (header != null && header.getHeaderMap() != null && !header.getHeaderMap().isEmpty()) {
                this.configureHeaderInRequest(request, header);
            }
            FutureResponseListener listener = new FutureResponseListener(request, 30485760);
            request.send((Response.CompleteListener)listener);
            ContentResponse contentResponse = listener.get();
            ServerResponse serverResponse = this.convertToServerResponse(contentResponse);
            return serverResponse;
        }
        catch (Exception e) {
            if (e instanceof WebClientException) {
                throw (WebClientException)e;
            }
            throw new WebClientException("URL- >" + url, (Throwable)e);
        }
        finally {
            this.stop();
        }
    }

    private ServerResponse convertToServerResponse(ContentResponse contentResponse) {
        ServerResponse response = new ServerResponse();
        response.setContent(contentResponse.getContent());
        String contentString = contentResponse.getContentAsString();
        response.setContentAsString(contentString);
        response.setEncoding(contentResponse.getEncoding());
        response.setMediaType(contentResponse.getMediaType());
        response.setStatus(contentResponse.getStatus());
        return response;
    }

    void start() {
        try {
            if (!this.isRunning()) {
                ((HttpClient)this.wrappedClient()).start();
            }
        }
        catch (Exception e) {
            throw new WebClientException((Throwable)e);
        }
    }

    void stop() {
        try {
            if (this.isRunning()) {
                ((HttpClient)this.wrappedClient()).stop();
            }
        }
        catch (Exception e) {
            throw new WebClientException((Throwable)e);
        }
    }

    boolean isRunning() {
        return ((HttpClient)this.wrappedClient()).isRunning();
    }

    public void addCookie(String url, Cookie cookie) {
        CookieStore cookieStore = ((HttpClient)this.wrappedClient()).getCookieStore();
        cookieStore.add(URI.create(url), this.createHttpCookie(cookie));
    }

    public void addProxy(Proxy proxy) {
        ProxyConfiguration proxyConfig = ((HttpClient)this.wrappedClient()).getProxyConfiguration();
        proxyConfig.getProxies().add(this.createHttpProxy(proxy));
    }

    private HttpProxy createHttpProxy(Proxy proxy) {
        HttpProxy httpProxy = new HttpProxy(new Origin.Address(proxy.host(), proxy.port()), proxy.isSecure());
        return httpProxy;
    }

    HttpCookie createHttpCookie(Cookie cookie) {
        HttpCookie httpCookie = new HttpCookie(cookie.name(), cookie.value());
        httpCookie.setDomain(cookie.domain());
        httpCookie.setHttpOnly(cookie.isHttpOnly());
        httpCookie.setMaxAge(cookie.maxAge());
        httpCookie.setSecure(cookie.isSecure());
        httpCookie.setVersion(cookie.version());
        httpCookie.setPath(cookie.path());
        return httpCookie;
    }
}

