/*
 * Decompiled with CFR 0.152.
 */
package org.appops.web.jetty.server;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.net.URL;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.appops.core.deployment.JettyConfig;
import org.appops.web.common.server.WebServer;
import org.appops.web.common.server.WebServerException;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyServer
extends WebServer<Server> {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());

    public JettyServer(int port) {
        super(port, (Object)new Server(port));
    }

    public JettyServer connect() {
        try {
            ((Server)this.wrappedServer()).start();
        }
        catch (Exception e) {
            throw new WebServerException((Throwable)e);
        }
        return this;
    }

    public void disconnect() {
        try {
            ((Server)this.wrappedServer()).stop();
        }
        catch (Exception e) {
            throw new WebServerException((Throwable)e);
        }
    }

    public boolean isConnected() {
        return ((Server)this.wrappedServer()).isRunning();
    }

    public void configureAppContext(String contextPath, URL webappDirOrWarPath, String serviceName, JettyConfig jettyConfig) {
        WebAppContext context = new WebAppContext();
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebInfConfiguration(), new WebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration(), new PlusConfiguration(), new JettyWebXmlConfiguration()});
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*");
        context.setContextPath(contextPath);
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*jstl.*\\.jar$");
        context.setAttribute("org.eclipse.jetty.server.Request.setAsyncSupported", (Object)true);
        if (webappDirOrWarPath.toString().endsWith(".war")) {
            context.setWar(webappDirOrWarPath.toString());
        } else {
            context.setBaseResource(JarResource.newResource((URL)webappDirOrWarPath));
        }
        this.configureDefaultSessionIdManager(context, serviceName);
        this.addSqlSessionHandler(context, jettyConfig);
        ((Server)this.wrappedServer()).insertHandler((HandlerWrapper)context);
    }

    public void configureDefaultSessionIdManager(WebAppContext context, String serviceName) {
        Server server = (Server)this.wrappedServer();
        DefaultSessionIdManager defaultSessionIdManager = new DefaultSessionIdManager(server);
        defaultSessionIdManager.setWorkerName(serviceName);
        server.setSessionIdManager((SessionIdManager)defaultSessionIdManager);
    }

    void addSqlSessionHandler(WebAppContext context, JettyConfig jettyConfig) {
        SessionHandler sessionHandler = context.getSessionHandler();
        DefaultSessionCache sessionCache = new DefaultSessionCache(sessionHandler);
        sessionCache.setSessionDataStore(this.getJdbcDataStoreFactory(jettyConfig.getDriver(), jettyConfig.getUrl(), jettyConfig.getUser(), jettyConfig.getPassword()).getSessionDataStore(sessionHandler));
        sessionHandler.setSessionCache((SessionCache)sessionCache);
        sessionHandler.setHttpOnly(true);
    }

    JDBCSessionDataStoreFactory getJdbcDataStoreFactory(String driver, String url, String user, String password) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(url);
        hikariConfig.addDataSourceProperty("url", (Object)url);
        hikariConfig.addDataSourceProperty("user", (Object)user);
        hikariConfig.addDataSourceProperty("password", (Object)password);
        HikariDataSource datasources = new HikariDataSource(hikariConfig);
        DatabaseAdaptor databaseAdaptor = new DatabaseAdaptor();
        databaseAdaptor.setDriverInfo(driver, url);
        databaseAdaptor.setDatasource((DataSource)datasources);
        JDBCSessionDataStoreFactory jdbcSessionDataStoreFactory = new JDBCSessionDataStoreFactory();
        jdbcSessionDataStoreFactory.setDatabaseAdaptor(databaseAdaptor);
        return jdbcSessionDataStoreFactory;
    }
}

