/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.approvej.scrub.Replacement;

public class RelativeDateReplacement
implements Replacement {
    private final DateTimeFormatter dateTimeFormatter;

    RelativeDateReplacement(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public String apply(String match, Integer count) {
        LocalDate parsed = this.dateTimeFormatter.parse((CharSequence)match, LocalDate::from);
        long days = Duration.between(LocalDate.now().atStartOfDay(), parsed.atStartOfDay()).toDays();
        if (days == 0L) {
            return "[today]";
        }
        if (days == 1L) {
            return "[tomorrow]";
        }
        if (days == -1L) {
            return "[yesterday]";
        }
        if (days > 1L) {
            return "[%d days from now]".formatted(days);
        }
        return "[%d days ago]".formatted(-days);
    }
}

