/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.print;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.approvej.print.Printer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ObjectPrinter<T>
implements Printer<T> {
    public static final Set<String> EXCLUDED_METHODS = Set.of("hashCode", "toString", "hash");
    public static final Set<Class<?>> SIMPLE_TYPES = Set.of(Boolean.class, Character.class, CharSequence.class, Class.class, Enum.class, Number.class, UUID.class, Temporal.class, TemporalAmount.class);
    private static final String PAIR_FORMAT = "%s=%s";

    public static <T> ObjectPrinter<T> objectPrinter() {
        return new ObjectPrinter<T>();
    }

    @Override
    public String apply(Object value) {
        return this.apply(value, "");
    }

    private String apply(@Nullable Object object, String baseIndent) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Collection.class}, (Object)object2, n)) {
            case 0 -> {
                Map map = (Map)object2;
                yield this.applyMap(map, baseIndent);
            }
            case 1 -> {
                Collection collection = (Collection)object2;
                yield this.applyCollection(collection, baseIndent);
            }
            case -1 -> this.applyObject("null", baseIndent);
            default -> this.applyObject(object, baseIndent);
        };
    }

    private String applyCollection(Collection<?> collection, String baseIndent) {
        String indent = baseIndent + "  ";
        return collection.stream().map(element -> this.apply(element, indent)).collect(Collectors.joining(",%n%s".formatted(indent), "[%n%s".formatted(indent), "%n%s]".formatted(baseIndent)));
    }

    private String applyMap(Map<?, ?> map, String baseIndent) {
        return this.applyCollection(new TreeMap(map).entrySet().stream().map(entry -> PAIR_FORMAT.formatted(entry.getKey(), this.apply(entry.getValue(), baseIndent + "  "))).toList(), baseIndent);
    }

    private String applyObject(@Nullable Object object, String baseIndent) {
        String indent = baseIndent + "  ";
        if (object == null || SIMPLE_TYPES.stream().anyMatch(simpleType -> simpleType.isAssignableFrom(object.getClass()))) {
            return "%s".formatted(object);
        }
        return Arrays.stream(object.getClass().getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).sorted(Comparator.comparing(Field::getName)).map(field -> PAIR_FORMAT.formatted(field.getName(), this.apply(this.getValue(object, (Field)field), indent))).collect(Collectors.joining(",%n%s".formatted(indent), "%s [%n%s".formatted(object.getClass().getSimpleName(), indent), "%n%s]".formatted(baseIndent)));
    }

    private @Nullable Object getValue(Object object, Field field) {
        String fieldName = field.getName();
        String capitalized = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        String methodNameRegex = String.format("(%s|get%s|is%s)", fieldName, capitalized, capitalized);
        return Arrays.stream(object.getClass().getDeclaredMethods()).filter(method -> method.getParameterCount() == 0).filter(method -> Void.class != method.getReturnType()).filter(method -> !EXCLUDED_METHODS.contains(method.getName())).filter(method -> method.getName().matches(methodNameRegex)).findFirst().map(method -> {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return "<inaccessible>";
            }
        }).orElse(null);
    }
}

