/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.time.format.DateTimeFormatter;
import org.approvej.scrub.RelativeDateReplacement;
import org.approvej.scrub.Replacement;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Replacements {
    private Replacements() {
    }

    public static Replacement numbered(String label) {
        return (match, count) -> String.format("[%s %d]", label, count);
    }

    public static Replacement numbered() {
        return Replacements.numbered("scrubbed");
    }

    public static Replacement string(String replacement) {
        return (match, count) -> replacement;
    }

    public static Replacement relativeDate(DateTimeFormatter dateTimeFormatter) {
        return new RelativeDateReplacement(dateTimeFormatter);
    }

    public static Replacement relativeDate(String dateTimePattern) {
        return Replacements.relativeDate(DateTimeFormatter.ofPattern(dateTimePattern));
    }

    public static Replacement masking() {
        return (match, count) -> match.replaceAll("\\p{M}", "").replaceAll("\\p{Lu}", "A").replaceAll("(\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo})", "a").replaceAll("\\p{N}", "1");
    }
}

