/*
 * Decompiled with CFR 0.152.
 */
package org.approvej;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.approvej.ConfigurationError;
import org.approvej.print.Printer;
import org.approvej.print.ToStringPrinter;
import org.approvej.review.FileReviewer;
import org.approvej.review.FileReviewerScript;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record Configuration(Printer<Object> defaultPrinter, @Nullable FileReviewer defaultFileReviewer) {
    private static final Properties DEFAULTS = new Properties();
    public static final Configuration configuration;

    private static Configuration loadConfiguration() {
        Printer printer;
        Properties properties = Configuration.loadProperties();
        String defaultPrinter = properties.getProperty("defaultPrinter");
        try {
            printer = (Printer)Class.forName(defaultPrinter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationError("Failed to create printer %s".formatted(defaultPrinter), e);
        }
        String defaultFileReviewerScript = properties.getProperty("defaultFileReviewerScript");
        FileReviewerScript defaultFileReviewer = null;
        if (defaultFileReviewerScript != null) {
            defaultFileReviewer = new FileReviewerScript(defaultFileReviewerScript);
        }
        return new Configuration(printer, defaultFileReviewer);
    }

    private static Properties loadProperties() {
        URL configurationFileUrl;
        Properties properties = new Properties(DEFAULTS);
        File userHomeProperties = new File(System.getProperty("user.home"), ".config/approvej/approvej.properties");
        if (userHomeProperties.exists()) {
            try (FileInputStream fis = new FileInputStream(userHomeProperties);){
                properties.load(fis);
            }
            catch (IOException e) {
                throw new ConfigurationError("Error loading configuration from home directory", e);
            }
        }
        if ((configurationFileUrl = Configuration.class.getClassLoader().getResource("approvej.properties")) == null) {
            return properties;
        }
        try (InputStream inputStream = configurationFileUrl.openStream();){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Failed to load configuration", e);
        }
        return properties;
    }

    static {
        DEFAULTS.setProperty("defaultPrinter", ToStringPrinter.class.getName());
        configuration = Configuration.loadConfiguration();
    }
}

