/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.approvej.approve.FileApproverError;
import org.approvej.approve.TestMethod;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StackTraceTestFinderUtil {
    private StackTraceTestFinderUtil() {
    }

    public static TestMethod currentTestMethod() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return (TestMethod)Arrays.stream(stackTrace).map(element -> {
            try {
                return Class.forName(element.getClassName()).getDeclaredMethod(element.getMethodName().replaceAll("^lambda\\$([^$]+)\\$\\d$", "$1"), new Class[0]);
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(TestMethod::create).filter(Optional::isPresent).findFirst().orElseThrow().orElseThrow();
    }

    public static Path findTestSourcePath(Method testMethod) {
        Path path2;
        block8: {
            Class<?> declaringClass = testMethod.getDeclaringClass();
            int packageDepth = declaringClass.getPackageName().split("\\.").length;
            String sourceSetName = Path.of(declaringClass.getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]).getFileName().toString();
            String packagePath = declaringClass.getPackageName().replace(".", "/");
            String pathRegex = "(?!build|target).*%s.*/%s/%s\\.(java|kt|groovy|scala)$".formatted(sourceSetName, packagePath, declaringClass.getSimpleName());
            Stream<Path> pathStream = Files.find(Path.of("", new String[0]), packageDepth + 10, (path, attributes) -> attributes.isRegularFile() && path.normalize().toString().matches(pathRegex), new FileVisitOption[0]);
            try {
                path2 = pathStream.findFirst().map(Path::toAbsolutePath).map(Path::normalize).orElseThrow(() -> new FileApproverError("Could not locate test source file"));
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileApproverError(e);
                }
            }
            pathStream.close();
        }
        return path2;
    }
}

