/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.print;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.approvej.print.Printer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ObjectPrinter<T>
implements Printer<T> {
    public static final Set<Class<?>> SIMPLE_TYPES = Set.of(Boolean.class, Character.class, CharSequence.class, Class.class, Enum.class, Number.class, UUID.class, Temporal.class, TemporalAmount.class);
    private static final String PAIR_FORMAT = "%s=%s";
    private Comparator<Field> fieldComparator = (field1, field2) -> 0;

    public static <T> ObjectPrinter<T> objectPrinter() {
        return new ObjectPrinter<T>();
    }

    public ObjectPrinter<T> sorted() {
        this.fieldComparator = Comparator.comparing(Field::getName);
        return this;
    }

    @Override
    public String apply(Object value) {
        return this.apply(value, "");
    }

    private String apply(@Nullable Object object, String baseIndent) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Collection.class}, (Object)object2, n)) {
            case 0 -> {
                Map map = (Map)object2;
                yield this.applyMap(map, baseIndent);
            }
            case 1 -> {
                Collection collection = (Collection)object2;
                yield this.applyCollection(collection, baseIndent);
            }
            case -1 -> this.applyObject("null", baseIndent);
            default -> this.applyObject(object, baseIndent);
        };
    }

    private String applyCollection(Collection<?> collection, String baseIndent) {
        if (collection.isEmpty()) {
            return "[]";
        }
        String indent = baseIndent + "  ";
        return collection.stream().map(element -> this.apply(element, indent)).collect(Collectors.joining(",%n%s".formatted(indent), "[%n%s".formatted(indent), "%n%s]".formatted(baseIndent)));
    }

    private String applyMap(Map<?, ?> map, String baseIndent) {
        return this.applyCollection(new TreeMap(map).entrySet().stream().map(entry -> PAIR_FORMAT.formatted(entry.getKey(), this.apply(entry.getValue(), baseIndent + "  "))).toList(), baseIndent);
    }

    private String applyObject(@Nullable Object object, String baseIndent) {
        String indent = baseIndent + "  ";
        if (object == null || SIMPLE_TYPES.stream().anyMatch(simpleType -> simpleType.isAssignableFrom(object.getClass()))) {
            return "%s".formatted(object);
        }
        return this.getFieldsAndGetters(object).filter(FieldAndGetter::hasGetter).map(fieldAndGetter -> PAIR_FORMAT.formatted(fieldAndGetter.field.getName(), this.apply(fieldAndGetter.value(), indent))).collect(Collectors.joining(",%n%s".formatted(indent), "%s [%n%s".formatted(object.getClass().getSimpleName(), indent), "%n%s]".formatted(baseIndent)));
    }

    private Stream<FieldAndGetter> getFieldsAndGetters(Object object) {
        return this.getFields(object).map(field -> new FieldAndGetter((Field)field, object));
    }

    private Stream<Field> getFields(Object object) {
        return this.getTypes(object).flatMap(aClass -> Arrays.stream(aClass.getDeclaredFields())).filter(field -> !Modifier.isStatic(field.getModifiers())).sorted(this.fieldComparator);
    }

    private Stream<Class<?>> getTypes(Object object) {
        return Stream.iterate(object.getClass(), type -> type != Object.class, Class::getSuperclass).toList().reversed().stream();
    }

    private record FieldAndGetter(Object object, Field field, Optional<Method> getter) {
        private FieldAndGetter(Field field, Object object) {
            this(object, field, Arrays.stream(field.getDeclaringClass().getDeclaredMethods()).filter(method -> method.getParameterCount() == 0 && Void.class != method.getReturnType() && method.getName().matches(String.format("(%s|get%2$s|is%2$s)", field.getName(), field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1)))).findFirst());
        }

        boolean hasGetter() {
            return this.getter.isPresent();
        }

        @Nullable Object value() {
            return this.getter.map(method -> {
                try {
                    return method.invoke(this.object, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return "<inaccessible>";
                }
            }).orElse(null);
        }
    }
}

