/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.review;

import java.io.IOException;
import java.util.logging.Logger;
import org.approvej.approve.PathProvider;
import org.approvej.review.FileReviewResult;
import org.approvej.review.FileReviewer;
import org.approvej.review.ReviewResult;

public record FileReviewerScript(String script) implements FileReviewer
{
    private static final String RECEIVED_PLACEHOLDER = "{receivedFile}";
    private static final String APPROVED_PLACEHOLDER = "{approvedFile}";
    private static final Logger LOGGER = Logger.getLogger(FileReviewerScript.class.getName());

    public static FileReviewerScript script(String script) {
        return new FileReviewerScript(script);
    }

    @Override
    public ReviewResult apply(PathProvider pathProvider) {
        try {
            String command = this.script.replace(RECEIVED_PLACEHOLDER, "%s".formatted(pathProvider.receivedPath())).replace(APPROVED_PLACEHOLDER, "%s".formatted(pathProvider.approvedPath()));
            Process process = new ProcessBuilder(new String[0]).command("sh", "-c", command).inheritIO().start();
            process.waitFor();
            return new FileReviewResult(process.exitValue() == 0);
        }
        catch (IOException e) {
            LOGGER.info("Review by %s failed with exception %s".formatted(this.getClass().getSimpleName(), e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("Review by %s was interrupted with exception %s".formatted(this.getClass().getSimpleName(), e));
        }
        return new FileReviewResult(false);
    }
}

