/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.print;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.approvej.print.Printer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ObjectPrinter<T>
implements Printer<T> {
    public static final Set<String> EXCLUDED_METHODS = Set.of("hashCode", "toString", "hash");
    public static final Set<Class<?>> SIMPLE_TYPES = Set.of(Boolean.class, Character.class, CharSequence.class, Number.class, UUID.class, Temporal.class, TemporalAmount.class);
    private static final String PAIR_FORMAT = "%s=%s";

    public static <T> ObjectPrinter<T> objectPrinter() {
        return new ObjectPrinter<T>();
    }

    private ObjectPrinter() {
    }

    @Override
    public String apply(Object value) {
        return this.apply(value, "");
    }

    private String apply(Object object, String baseIndent) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Collection.class}, (Object)object3, n)) {
            case 0 -> {
                Map map = (Map)object3;
                yield this.applyMap(map, baseIndent);
            }
            case 1 -> {
                Collection collection = (Collection)object3;
                yield this.applyCollection(collection, baseIndent);
            }
            default -> this.applyObject(object, baseIndent);
        };
    }

    private String applyCollection(Collection<?> collection, String baseIndent) {
        String indent = baseIndent + "  ";
        return collection.stream().map(element -> this.apply(element, indent)).collect(Collectors.joining(",%n%s".formatted(indent), "[%n%s".formatted(indent), "%n%s]".formatted(baseIndent)));
    }

    private String applyMap(Map<?, ?> map, String baseIndent) {
        return this.applyCollection(new TreeMap(map).entrySet().stream().map(entry -> PAIR_FORMAT.formatted(entry.getKey(), this.apply(entry.getValue(), baseIndent + "  "))).toList(), baseIndent);
    }

    private String applyObject(Object object, String baseIndent) {
        String indent = baseIndent + "  ";
        Class<?> type = object.getClass();
        if (SIMPLE_TYPES.stream().anyMatch(simpleType -> simpleType.isAssignableFrom(type))) {
            return object.toString();
        }
        return Arrays.stream(object.getClass().getDeclaredMethods()).filter(method -> !EXCLUDED_METHODS.contains(method.getName())).filter(method -> method.getParameterCount() == 0).filter(method -> Void.class != method.getReturnType()).sorted(Comparator.comparing(Method::getName)).map(method -> {
            try {
                return PAIR_FORMAT.formatted(method.getName(), this.apply(method.invoke(object, new Object[0]), indent));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return PAIR_FORMAT.formatted(method.getName(), "<inaccessible>");
            }
        }).collect(Collectors.joining(",%n%s".formatted(indent), "%s [%n%s".formatted(object.getClass().getSimpleName(), indent), "%n%s]".formatted(baseIndent)));
    }
}

