/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.approvej.scrub.Scrubber;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RegexScrubber
implements Scrubber<String> {
    public static final Function<Integer, String> NUMBERED_REPLACEMENT = arg_0 -> RegexScrubber.lambda$static$0("[scrubbed %d]", arg_0);
    private final Pattern pattern;
    private final Function<Integer, String> replacement;

    public static RegexScrubberBuilder stringsMatching(Pattern pattern) {
        return new RegexScrubberBuilder(pattern);
    }

    public static RegexScrubberBuilder stringsMatching(String pattern) {
        return new RegexScrubberBuilder(Pattern.compile(pattern));
    }

    protected RegexScrubber(Pattern pattern, Function<Integer, String> replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public String apply(String unscrubbedValue) {
        Matcher matcher = this.pattern.matcher(unscrubbedValue);
        HashMap findings = new HashMap();
        Function<MatchResult, String> replacer = result -> {
            String group = result.group();
            findings.putIfAbsent(group, findings.size() + 1);
            return this.replacement.apply((Integer)findings.get(group));
        };
        return matcher.replaceAll(replacer);
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "[scrubbed %d]".formatted(xva$0);
    }

    public static class RegexScrubberBuilder {
        private final Pattern pattern;

        private RegexScrubberBuilder(Pattern pattern) {
            this.pattern = pattern;
        }

        public RegexScrubber with(Function<Integer, String> replacement) {
            return new RegexScrubber(this.pattern, replacement);
        }

        public RegexScrubber with(String staticReplacement) {
            return new RegexScrubber(this.pattern, number -> staticReplacement);
        }

        public RegexScrubber withNumberedReplacement() {
            return new RegexScrubber(this.pattern, NUMBERED_REPLACEMENT);
        }
    }
}

