/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.approvej.scrub.Scrubber;

public class RelativeDateScrubber
implements Scrubber<String> {
    private static final LocalDate EXAMPLE_DATE = LocalDate.of(4567, 12, 30);
    private final Pattern pattern;
    private final UnaryOperator<String> replacement;

    public static RelativeDateScrubber relativeDates(DateTimeFormatter dateFormatPattern) {
        return new RelativeDateScrubber(dateFormatPattern);
    }

    private RelativeDateScrubber(DateTimeFormatter dateFormatPattern) {
        this.pattern = Pattern.compile(dateFormatPattern.format(EXAMPLE_DATE).replaceAll("\\p{L}+", "\\\\p{L}+").replaceAll("\\d", "\\\\d"));
        this.replacement = finding -> {
            LocalDate parsed = dateFormatPattern.parse((CharSequence)finding, LocalDate::from);
            long days = Duration.between(LocalDate.now().atStartOfDay(), parsed.atStartOfDay()).toDays();
            if (days == 0L) {
                return "[today]";
            }
            if (days == 1L) {
                return "[tomorrow]";
            }
            if (days == -1L) {
                return "[yesterday]";
            }
            if (days > 1L) {
                return "[%d days from now]".formatted(days);
            }
            return "[%d days ago]".formatted(-days);
        };
    }

    @Override
    public String apply(String unscrubbedValue) {
        return this.pattern.matcher(unscrubbedValue).replaceAll(result -> (String)this.replacement.apply(result.group()));
    }
}

