/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.approvej.scrub.RegexScrubber;
import org.approvej.scrub.Replacements;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UuidScrubber {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");

    public static RegexScrubber uuids(Function<Integer, Object> replacement) {
        return RegexScrubber.stringsMatching(UUID_PATTERN).with(replacement);
    }

    public static RegexScrubber uuids() {
        return RegexScrubber.stringsMatching(UUID_PATTERN).with(Replacements.numbered("uuid"));
    }

    private UuidScrubber() {
    }
}

