/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.verify;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.approvej.ApprovalError;
import org.approvej.verify.Verifier;
import org.junit.jupiter.api.Test;

public class FileVerifier
implements Verifier {
    private final PathProvider pathProvider;

    public static FileVerifier file(PathProvider pathProvider) {
        return new FileVerifier(pathProvider);
    }

    public static FileVerifier file() {
        return new FileVerifier(new StackTracePathProvider());
    }

    public static FileVerifier file(String filenameExtension) {
        return new FileVerifier(new StackTracePathProvider(filenameExtension));
    }

    private FileVerifier(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
    }

    @Override
    public void accept(String received) {
        String trimmed = received.trim();
        try {
            String previouslyApproved;
            if (!Files.exists(this.pathProvider.approvedPath(), new LinkOption[0])) {
                Files.createFile(this.pathProvider.approvedPath(), new FileAttribute[0]);
            }
            if (!(previouslyApproved = Files.readString(this.pathProvider.approvedPath()).trim()).equals(trimmed)) {
                Files.writeString(this.pathProvider.receivedPath(), (CharSequence)trimmed, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                throw new ApprovalError(trimmed, previouslyApproved);
            }
            Files.deleteIfExists(this.pathProvider.receivedPath());
        }
        catch (IOException e) {
            throw new FileVerifierError(e);
        }
    }

    public static interface PathProvider {
        public static final String RECEIVED = "received";
        public static final String APPROVED = "approved";

        public Path receivedPath();

        public Path approvedPath();
    }

    public static final class StackTracePathProvider
    implements PathProvider {
        private final Path receivedPath;
        private final Path approvedPath;

        StackTracePathProvider(String filenameExtension) {
            Method method = this.currentTestMethod();
            Path basePath = Stream.of("src/test/java/%s", "src/test/kotlin/%s", "src/test/groovy/%s").map(format -> Path.of(format.formatted(method.getDeclaringClass().getPackageName().replace(".", "/")), new String[0])).filter(path -> path.toFile().exists()).findFirst().orElseThrow(() -> new FileVerifierError("No attempted base path exists"));
            String fileNamePattern = "%s-%s-%%s.%s".formatted(method.getDeclaringClass().getSimpleName(), method.getName(), filenameExtension);
            this.receivedPath = basePath.resolve(fileNamePattern.formatted("received"));
            this.approvedPath = basePath.resolve(fileNamePattern.formatted("approved"));
        }

        StackTracePathProvider() {
            this("txt");
        }

        @Override
        public Path approvedPath() {
            return this.approvedPath;
        }

        @Override
        public Path receivedPath() {
            return this.receivedPath;
        }

        private Method currentTestMethod() {
            return Arrays.stream(Thread.currentThread().getStackTrace()).map(element -> {
                try {
                    return Class.forName(element.getClassName()).getDeclaredMethod(element.getMethodName(), new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    return null;
                }
            }).filter(method -> method != null && method.isAnnotationPresent(Test.class)).findFirst().orElseThrow();
        }
    }

    static class FileVerifierError
    extends RuntimeException {
        public FileVerifierError(String message) {
            super(message);
        }

        public FileVerifierError(Throwable cause) {
            super("Failed to verify file", cause);
        }
    }

    public static final class BasePathProvider
    implements PathProvider {
        private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(?<baseName>.+?)(?<approved>-approved)?(?:\\.(?<extension>[^.]*))?$");
        private final Path receivedPath;
        private final Path approvedPath;

        public static BasePathProvider approvedPath(Path approvedPath) {
            return new BasePathProvider(approvedPath);
        }

        public static BasePathProvider approvedPath(String approvedPath) {
            return BasePathProvider.approvedPath(Path.of(approvedPath, new String[0]));
        }

        private BasePathProvider(Path approvedPath) {
            this.approvedPath = approvedPath;
            Path parentPath = approvedPath.getParent();
            Matcher matcher = FILE_NAME_PATTERN.matcher(approvedPath.getFileName().toString());
            String baseName = matcher.matches() ? matcher.group("baseName") : approvedPath.getFileName().toString();
            String extension = matcher.matches() ? Objects.requireNonNullElseGet(matcher.group("extension"), () -> "txt") : "txt";
            this.receivedPath = parentPath.resolve("%s-%s.%s".formatted(baseName, "received", extension));
        }

        @Override
        public Path receivedPath() {
            return this.receivedPath;
        }

        @Override
        public Path approvedPath() {
            return this.approvedPath;
        }
    }
}

