/*
 * Decompiled with CFR 0.152.
 */
package org.approvej;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.approvej.print.Printer;
import org.approvej.verify.Verifiers;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ApprovalBuilder<T> {
    public static final Printer<Object> DEFAULT_PRINTER = Object::toString;
    private T value;

    private ApprovalBuilder(T originalValue) {
        this.value = originalValue;
    }

    public static <T> ApprovalBuilder<T> approve(T originalValue) {
        return new ApprovalBuilder<T>(originalValue);
    }

    public ApprovalBuilder<String> printWith(Function<T, String> printer) {
        return new ApprovalBuilder<String>(printer.apply(this.value));
    }

    public ApprovalBuilder<T> scrubbedOf(UnaryOperator<T> scrubber) {
        this.value = scrubber.apply(this.value);
        return this;
    }

    public void verify(Consumer<String> verifier) {
        T t = this.value;
        if (t instanceof String) {
            String printedValue = (String)t;
            verifier.accept(printedValue);
        } else {
            verifier.accept((String)DEFAULT_PRINTER.apply(this.value));
        }
    }

    public void verify(String previouslyApproved) {
        this.verify(Verifiers.inplace(previouslyApproved));
    }

    public void verify() {
        this.verify(Verifiers.inFile());
    }
}

