/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.approvej.scrub.RegexScrubber;
import org.approvej.scrub.RelativeDateScrubber;
import org.approvej.scrub.Replacements;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Scrubbers {
    private static final LocalDate EXAMPLE_DATE = LocalDate.of(4567, 12, 30);
    private static final ZonedDateTime EXAMPLE_INSTANT = ZonedDateTime.now();

    private Scrubbers() {
    }

    public static RegexScrubber.RegexScrubberBuilder stringsMatching(Pattern pattern) {
        return new RegexScrubber.RegexScrubberBuilder(pattern);
    }

    public static RegexScrubber.RegexScrubberBuilder stringsMatching(String pattern) {
        return Scrubbers.stringsMatching(Pattern.compile(pattern));
    }

    public static RegexScrubber.RegexScrubberBuilder dates(DateTimeFormatter dateFormatPattern) {
        return Scrubbers.stringsMatching(Pattern.compile(dateFormatPattern.format(EXAMPLE_DATE).replaceAll("\\p{L}+", "\\\\p{L}+").replaceAll("\\d", "\\\\d"))).replacement(Replacements.numbered("date"));
    }

    public static RegexScrubber.RegexScrubberBuilder instants(DateTimeFormatter dateFormatPattern) {
        return Scrubbers.stringsMatching(Pattern.compile(dateFormatPattern.format(EXAMPLE_INSTANT).replaceAll("\\p{L}+", "\\\\p{L}+").replaceAll("\\d", "\\\\d"))).replacement(Replacements.numbered("instant"));
    }

    public static RegexScrubber.RegexScrubberBuilder uuids() {
        return Scrubbers.stringsMatching(Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")).replacement(Replacements.numbered("uuid"));
    }

    public static RelativeDateScrubber relativeDates(DateTimeFormatter dateFormatPattern) {
        return new RelativeDateScrubber(dateFormatPattern);
    }
}

