/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.verify;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.approvej.ApprovalError;
import org.approvej.verify.FileVerifierError;
import org.approvej.verify.PathProvider;
import org.approvej.verify.Verifier;

public class FileVerifier
implements Verifier {
    private final PathProvider pathProvider;

    FileVerifier(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
    }

    @Override
    public void accept(String received) {
        String trimmed = received.trim();
        try {
            String previouslyApproved;
            Files.createDirectories(this.pathProvider.directory(), new FileAttribute[0]);
            if (Files.notExists(this.pathProvider.approvedPath(), new LinkOption[0])) {
                Files.createFile(this.pathProvider.approvedPath(), new FileAttribute[0]);
            }
            if (!(previouslyApproved = Files.readString(this.pathProvider.approvedPath()).trim()).equals(trimmed)) {
                Files.writeString(this.pathProvider.receivedPath(), (CharSequence)trimmed, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                throw new ApprovalError(trimmed, previouslyApproved);
            }
            Files.deleteIfExists(this.pathProvider.receivedPath());
        }
        catch (IOException e) {
            throw new FileVerifierError(e);
        }
    }
}

