/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.verify;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.approvej.verify.FileVerifierError;
import org.approvej.verify.PathProvider;
import org.approvej.verify.PathProviderBuilder;
import org.approvej.verify.StackTraceTestFinderUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class NextToTestPathProvider
implements PathProvider {
    private final Path directory;
    private final String fileNamePattern;

    NextToTestPathProvider(String filenameExtension, boolean subdirectory) {
        Method testMethod = StackTraceTestFinderUtil.currentTestMethod();
        Path testSourcePath = this.findTestSourcePath(testMethod);
        this.directory = subdirectory ? testSourcePath.getParent().resolve(testMethod.getDeclaringClass().getSimpleName()) : testSourcePath.getParent();
        this.fileNamePattern = subdirectory ? "%s-%%s.%s".formatted(testMethod.getName(), filenameExtension) : "%s-%s-%%s.%s".formatted(testMethod.getDeclaringClass().getSimpleName(), testMethod.getName(), filenameExtension);
    }

    private Path findTestSourcePath(Method testMethod) {
        Path path2;
        block8: {
            String packagePath = testMethod.getDeclaringClass().getPackageName().replace(".", "/");
            String pathRegex = ".*%s/%s\\.(java|kt|groovy)$".formatted(packagePath, testMethod.getDeclaringClass().getSimpleName());
            Stream<Path> pathStream = Files.find(Path.of(".", new String[0]), 10, (path, attributes) -> attributes.isRegularFile() && path.toString().matches(pathRegex), new FileVisitOption[0]);
            try {
                path2 = pathStream.findFirst().orElseThrow(() -> new FileVerifierError("Could not locate test source file"));
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileVerifierError(e);
                }
            }
            pathStream.close();
        }
        return path2;
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public Path receivedPath() {
        return this.directory.resolve(this.fileNamePattern.formatted("received"));
    }

    @Override
    public Path approvedPath() {
        return this.directory.resolve(this.fileNamePattern.formatted("approved"));
    }

    public static class NextToTestPathProviderBuilder
    implements PathProviderBuilder {
        private String filenameExtension = "txt";
        private boolean subdirectory = false;

        NextToTestPathProviderBuilder() {
        }

        public NextToTestPathProviderBuilder filenameExtension(String filenameExtension) {
            this.filenameExtension = filenameExtension;
            return this;
        }

        public NextToTestPathProviderBuilder inSubdirectory() {
            this.subdirectory = true;
            return this;
        }

        @Override
        public PathProvider build() {
            return new NextToTestPathProvider(this.filenameExtension, this.subdirectory);
        }
    }
}

