/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.verify;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.jupiter.api.Test;

class StackTraceTestFinderUtil {
    private StackTraceTestFinderUtil() {
    }

    static Method currentTestMethod() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(element -> {
            try {
                return Class.forName(element.getClassName()).getDeclaredMethod(element.getMethodName(), new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                return null;
            }
        }).filter(method -> method != null && method.isAnnotationPresent(Test.class)).findFirst().orElseThrow();
    }
}

