/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.verify;

import java.nio.file.Path;
import org.approvej.verify.FileVerifier;
import org.approvej.verify.InplaceVerifier;
import org.approvej.verify.PathProvider;
import org.approvej.verify.PathProviderBuilder;
import org.approvej.verify.PathProviders;

public class Verifiers {
    private Verifiers() {
    }

    public static InplaceVerifier inplace(String previouslyApproved) {
        return new InplaceVerifier(previouslyApproved);
    }

    public static FileVerifier inFile(PathProvider pathProvider) {
        return new FileVerifier(pathProvider);
    }

    public static FileVerifier inFile(PathProviderBuilder pathProviderBuilder) {
        return Verifiers.inFile(pathProviderBuilder.build());
    }

    public static FileVerifier inFile() {
        return Verifiers.inFile(PathProviders.nextToTest());
    }

    public static FileVerifier inFile(Path approvedPath) {
        return Verifiers.inFile(PathProviders.approvedPath(approvedPath));
    }

    public static FileVerifier inFile(String approvedPath) {
        return Verifiers.inFile(Path.of(approvedPath, new String[0]));
    }
}

