/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.nio.file.Path;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.approvej.approve.PathProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ApprovedPathProvider
implements PathProvider {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(?<baseName>.+?)(?<approved>[-_. ]approved)?(?:\\.(?<extension>[^.]*))?$");
    private final Path directory;
    private final Path receivedPath;
    private final Path approvedPath;

    ApprovedPathProvider(Path approvedPath) {
        this.approvedPath = approvedPath;
        this.directory = approvedPath.getParent();
        Path parentPath = approvedPath.getParent();
        Matcher matcher = FILE_NAME_PATTERN.matcher(approvedPath.getFileName().toString());
        String baseName = matcher.matches() ? matcher.group("baseName") : approvedPath.getFileName().toString();
        String extension = matcher.matches() ? Objects.requireNonNullElse(matcher.group("extension"), "txt") : "txt";
        this.receivedPath = parentPath.resolve("%s-%s.%s".formatted(baseName, "received", extension));
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public Path receivedPath() {
        return this.receivedPath;
    }

    @Override
    public Path approvedPath() {
        return this.approvedPath;
    }
}

