/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.approvej.ApprovalError;
import org.approvej.approve.Approver;
import org.approvej.approve.FileVerifierError;
import org.approvej.approve.PathProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FileApprover
implements Approver {
    private final PathProvider pathProvider;

    FileApprover(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
    }

    @Override
    public void accept(String received) {
        String trimmed = received.trim();
        FileApprover.doIoOp("create directories %s".formatted(this.pathProvider.directory()), () -> Files.createDirectories(this.pathProvider.directory(), new FileAttribute[0]));
        Path approvedPath = this.pathProvider.approvedPath();
        if (Files.notExists(approvedPath, new LinkOption[0])) {
            FileApprover.doIoOp("create approved file %s".formatted(approvedPath), () -> Files.createFile(approvedPath, new FileAttribute[0]));
        }
        String previouslyApproved = FileApprover.doIoOp("read approved file %s".formatted(approvedPath), () -> Files.readString(approvedPath).trim());
        Path receivedPath = this.pathProvider.receivedPath();
        if (!previouslyApproved.equals(trimmed)) {
            FileApprover.doIoOp("write received to %s".formatted(receivedPath), () -> Files.writeString(receivedPath, (CharSequence)trimmed, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
            throw new ApprovalError(trimmed, previouslyApproved);
        }
        FileApprover.doIoOp("delete received file %s".formatted(receivedPath), () -> Files.deleteIfExists(receivedPath));
    }

    private static <T> T doIoOp(String description, IoOp<T> op) {
        try {
            return op.call();
        }
        catch (IOException e) {
            throw new FileVerifierError("Failed to %s".formatted(description), e);
        }
    }

    @FunctionalInterface
    private static interface IoOp<T>
    extends Callable<T> {
        @Override
        public T call() throws IOException;
    }
}

