/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.lang.reflect.Method;
import java.nio.file.Path;
import org.approvej.approve.PathProvider;
import org.approvej.approve.StackTraceTestFinderUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class NextToTestPathProvider
implements PathProvider {
    private final Path testSourcePath;
    private final String testClassSimpleName;
    private final String testMethodName;
    private Path directory;
    private String fileNamePattern;
    private String filenameExtension;

    NextToTestPathProvider() {
        Method testMethod = StackTraceTestFinderUtil.currentTestMethod();
        this.testSourcePath = StackTraceTestFinderUtil.findTestSourcePath(testMethod);
        this.testClassSimpleName = testMethod.getDeclaringClass().getSimpleName();
        this.testMethodName = testMethod.getName();
        this.directory = this.testSourcePath.getParent();
        this.fileNamePattern = "%s-%s-%%s.%%s".formatted(this.testClassSimpleName, this.testMethodName);
        this.filenameExtension = "txt";
    }

    public NextToTestPathProvider inSubdirectory() {
        this.directory = this.testSourcePath.getParent().resolve(this.testClassSimpleName);
        this.fileNamePattern = "%s-%%s.%%s".formatted(this.testMethodName);
        return this;
    }

    public NextToTestPathProvider filenameExtension(String filenameExtension) {
        this.filenameExtension = filenameExtension;
        return this;
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public Path receivedPath() {
        return this.directory.resolve(this.fileNamePattern.formatted("received", this.filenameExtension));
    }

    @Override
    public Path approvedPath() {
        return this.directory.resolve(this.fileNamePattern.formatted("approved", this.filenameExtension));
    }
}

