/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import org.approvej.approve.FileVerifierError;
import org.jspecify.annotations.NullMarked;
import org.junit.jupiter.api.Test;

@NullMarked
public class StackTraceTestFinderUtil {
    private StackTraceTestFinderUtil() {
    }

    public static Method currentTestMethod() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(element -> {
            try {
                return Class.forName(element.getClassName()).getDeclaredMethod(element.getMethodName(), new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                return null;
            }
        }).filter(method -> method != null && method.isAnnotationPresent(Test.class)).findFirst().orElseThrow();
    }

    public static Path findTestSourcePath(Method testMethod) {
        Path path2;
        block8: {
            String packagePath = testMethod.getDeclaringClass().getPackageName().replace(".", "/");
            String pathRegex = ".*%s/%s\\.(java|kt|groovy)$".formatted(packagePath, testMethod.getDeclaringClass().getSimpleName());
            Stream<Path> pathStream = Files.find(Path.of(".", new String[0]), 10, (path, attributes) -> attributes.isRegularFile() && path.toString().matches(pathRegex), new FileVisitOption[0]);
            try {
                path2 = pathStream.findFirst().orElseThrow(() -> new FileVerifierError("Could not locate test source file"));
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileVerifierError(e);
                }
            }
            pathStream.close();
        }
        return path2;
    }
}

