/*
 * Decompiled with CFR 0.152.
 */
package org.approvej;

import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.approvej.Configuration;
import org.approvej.approve.Approvers;
import org.approvej.approve.PathProvider;
import org.approvej.approve.PathProviderBuilder;
import org.approvej.print.Printer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ApprovalBuilder<T> {
    private T receivedValue;
    private final String filenameExtension;

    private ApprovalBuilder(T originalValue, String filenameExtension) {
        this.receivedValue = originalValue;
        this.filenameExtension = filenameExtension;
    }

    public static <T> ApprovalBuilder<T> approve(T originalValue) {
        return new ApprovalBuilder<T>(originalValue, "txt");
    }

    public ApprovalBuilder<String> printWith(Function<T, String> printer) {
        return new ApprovalBuilder<String>(printer.apply(this.receivedValue), "txt");
    }

    public ApprovalBuilder<String> printWith(Printer<T> printer) {
        return new ApprovalBuilder<String>((String)printer.apply(this.receivedValue), printer.filenameExtension());
    }

    public ApprovalBuilder<T> scrubbedOf(UnaryOperator<T> scrubber) {
        this.receivedValue = scrubber.apply(this.receivedValue);
        return this;
    }

    public void by(Consumer<String> approver) {
        T t = this.receivedValue;
        if (t instanceof String) {
            String printedValue = (String)t;
            approver.accept(printedValue);
        } else {
            this.printWith(Configuration.configuration.defaultPrinter()).by(approver);
        }
    }

    public void byValue(String previouslyApproved) {
        this.by(Approvers.value(previouslyApproved));
    }

    public void byFile(PathProvider pathProvider) {
        this.by(Approvers.file(pathProvider));
    }

    public void byFile(PathProviderBuilder pathProviderBuilder) {
        T t = this.receivedValue;
        if (t instanceof String) {
            String printedValue = (String)t;
            Approvers.file(pathProviderBuilder.filenameExtension(this.filenameExtension)).accept(printedValue);
        } else {
            this.printWith(Configuration.configuration.defaultPrinter()).byFile(pathProviderBuilder);
        }
    }

    public void byFile() {
        this.byFile(PathProviderBuilder.nextToTest());
    }

    public void byFile(Path approvedPath) {
        this.byFile(PathProviderBuilder.approvedPath(approvedPath));
    }

    public void byFile(String approvedPath) {
        this.byFile(PathProviderBuilder.approvedPath(Path.of(approvedPath, new String[0])));
    }
}

