/*
 * Decompiled with CFR 0.152.
 */
package org.approvej;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.approvej.ConfigurationError;
import org.approvej.print.Printer;
import org.approvej.print.ToStringPrinter;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record Configuration(Printer<Object> defaultPrinter) {
    public static final Configuration configuration = Configuration.loadConfiguration();
    private static final Properties DEFAULTS = new Properties();

    private static Configuration loadConfiguration() {
        Printer printer;
        Properties properties = Configuration.loadProperties();
        String defaultPrinter = properties.getProperty("defaultPrinter");
        try {
            printer = (Printer)Class.forName(defaultPrinter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationError("Failed to create printer %s".formatted(defaultPrinter), e);
        }
        return new Configuration(printer);
    }

    private static Properties loadProperties() {
        Properties properties = new Properties(DEFAULTS);
        try (InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream("approvej.properties");){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Failed to load configuration", e);
        }
        return properties;
    }

    static {
        DEFAULTS.setProperty("defaultPrinter", ToStringPrinter.class.getName());
    }
}

