/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.nio.file.Path;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.approvej.approve.PathProvider;
import org.approvej.approve.PathProviderRecord;
import org.approvej.approve.StackTraceTestFinderUtil;
import org.approvej.approve.TestMethod;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PathProviderBuilder {
    public static final String RECEIVED = "received";
    public static final String APPROVED = "approved";
    private Path directory = Path.of(".", new String[0]);
    private String receivedBaseFilename = "received";
    private String approvedBaseFilename = "approved";

    public static PathProvider approvedPath(Path approvedPath) {
        Pattern approvedFilenamePattern = Pattern.compile("(?<baseName>.+?)(?<approved>[-_. ]approved)?(?:\\.(?<extension>[^.]*))?$");
        Path directory = approvedPath.getParent();
        String approvedFilename = approvedPath.getFileName().toString();
        Matcher matcher = approvedFilenamePattern.matcher(approvedFilename);
        String baseName = matcher.matches() ? matcher.group("baseName") : approvedFilename;
        String filenameExtension = matcher.matches() ? Objects.requireNonNullElse(matcher.group("extension"), "txt") : "txt";
        String receivedFilename = "%s-%s.%s".formatted(baseName, RECEIVED, filenameExtension);
        return new PathProviderRecord(directory, approvedFilename, receivedFilename);
    }

    public static PathProvider approvedPath(String approvedPathString) {
        return PathProviderBuilder.approvedPath(Path.of(approvedPathString, new String[0]));
    }

    public static PathProviderBuilder nextToTest() {
        TestMethod testMethod = StackTraceTestFinderUtil.currentTestMethod();
        Path directory = StackTraceTestFinderUtil.findTestSourcePath(testMethod.method()).getParent();
        String baseFilename = "%s-%s".formatted(testMethod.testClass().getSimpleName(), testMethod.testCaseName());
        return new PathProviderBuilder().directory(directory).receivedBaseFilename("%s-%s".formatted(baseFilename, RECEIVED)).approvedBaseFilename("%s-%s".formatted(baseFilename, APPROVED));
    }

    public static PathProviderBuilder nextToTestInSubdirectory() {
        TestMethod testMethod = StackTraceTestFinderUtil.currentTestMethod();
        Path directory = StackTraceTestFinderUtil.findTestSourcePath(testMethod.method()).getParent().resolve(testMethod.testClass().getSimpleName());
        String baseFilename = "%s".formatted(testMethod.testCaseName());
        return new PathProviderBuilder().directory(directory).receivedBaseFilename("%s-%s".formatted(baseFilename, RECEIVED)).approvedBaseFilename("%s-%s".formatted(baseFilename, APPROVED));
    }

    private PathProviderBuilder() {
    }

    public PathProviderBuilder directory(Path directory) {
        this.directory = directory;
        return this;
    }

    public PathProviderBuilder approvedBaseFilename(String approvedFilename) {
        this.approvedBaseFilename = approvedFilename;
        return this;
    }

    public PathProviderBuilder receivedBaseFilename(String receivedFilename) {
        this.receivedBaseFilename = receivedFilename;
        return this;
    }

    public PathProvider filenameExtension(String filenameExtension) {
        return new PathProviderRecord(this.directory, "%s.%s".formatted(this.approvedBaseFilename, filenameExtension), "%s.%s".formatted(this.receivedBaseFilename, filenameExtension));
    }
}

