/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.review;

import java.io.IOException;
import java.nio.file.Files;
import org.approvej.ApprovalResult;
import org.approvej.approve.FileApprovalResult;
import org.approvej.approve.PathProvider;
import org.approvej.review.FileReviewer;
import org.approvej.review.ReviewerError;

public record FileReviewerScript(String script) implements FileReviewer
{
    private static final String RECEIVED_PLACEHOLDER = "{receivedFile}";
    private static final String APPROVED_PLACEHOLDER = "{approvedFile}";

    @Override
    public ApprovalResult apply(PathProvider pathProvider) {
        try {
            String command = this.script.replace(RECEIVED_PLACEHOLDER, pathProvider.receivedPath().toString()).replace(APPROVED_PLACEHOLDER, pathProvider.approvedPath().toString());
            new ProcessBuilder(command.split("\\s+")).inheritIO().start().waitFor();
            return new FileApprovalResult(Files.readString(pathProvider.receivedPath()), Files.readString(pathProvider.approvedPath()), pathProvider);
        }
        catch (IOException e) {
            throw new ReviewerError("Review by %s failed".formatted(this.getClass().getSimpleName()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReviewerError("Review by %s was interrupted".formatted(this.getClass().getSimpleName()), e);
        }
    }
}

