/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.approvej.scrub.DateTimeScrubber;
import org.approvej.scrub.RegexScrubber;
import org.approvej.scrub.RelativeDateScrubber;
import org.approvej.scrub.Replacements;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Scrubbers {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");

    private Scrubbers() {
    }

    public static RegexScrubber stringsMatching(Pattern pattern) {
        return new RegexScrubber(pattern, Replacements.numbered());
    }

    public static RegexScrubber stringsMatching(String pattern) {
        return Scrubbers.stringsMatching(Pattern.compile(pattern));
    }

    public static RegexScrubber dateTimeFormat(String dateTimePattern, Locale locale) {
        return new DateTimeScrubber(dateTimePattern, locale, Replacements.numbered("datetime"));
    }

    public static RegexScrubber dateTimeFormat(String dateTimePattern) {
        return Scrubbers.dateTimeFormat(dateTimePattern, Locale.getDefault());
    }

    public static RegexScrubber uuids() {
        return Scrubbers.stringsMatching(UUID_PATTERN).replacement(Replacements.numbered("uuid"));
    }

    public static RelativeDateScrubber relativeDates(DateTimeFormatter dateFormatPattern) {
        return new RelativeDateScrubber(dateFormatPattern);
    }
}

