/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.approvej.ApprovalResult;
import org.approvej.approve.Approver;
import org.approvej.approve.FileApprovalResult;
import org.approvej.approve.FileApproverError;
import org.approvej.approve.PathProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FileApprover
implements Approver {
    private final PathProvider pathProvider;

    FileApprover(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
    }

    @Override
    public ApprovalResult apply(String received) {
        this.ensureDirectory();
        this.ensureApprovedFile();
        return this.check(this.readApprovedFile(), received.trim());
    }

    private void ensureDirectory() {
        try {
            Files.createDirectories(this.pathProvider.directory(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FileApproverError("Creating directories %s failed".formatted(this.pathProvider.directory()), e);
        }
    }

    private void ensureApprovedFile() {
        Path approvedPath = this.pathProvider.approvedPath();
        if (Files.notExists(approvedPath, new LinkOption[0])) {
            try {
                Files.createFile(approvedPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new FileApproverError("Creating approved file %s failed".formatted(approvedPath), e);
            }
        }
    }

    private String readApprovedFile() {
        Path approvedPath = this.pathProvider.approvedPath();
        try {
            return Files.readString(approvedPath).trim();
        }
        catch (IOException e) {
            throw new FileApproverError("Reading approved file %s failed".formatted(approvedPath), e);
        }
    }

    private ApprovalResult check(String previouslyApproved, String receivedTrimmed) {
        FileApprovalResult result = new FileApprovalResult(previouslyApproved, receivedTrimmed, this.pathProvider);
        Path receivedPath = this.pathProvider.receivedPath();
        if (result.needsApproval()) {
            try {
                Files.writeString(receivedPath, (CharSequence)(receivedTrimmed + "\n"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new FileApproverError("Writing received to %s failed".formatted(receivedPath), e);
            }
            return result;
        }
        try {
            Files.deleteIfExists(receivedPath);
            return result;
        }
        catch (IOException e) {
            throw new FileApproverError("Deleting received file %s failed".formatted(receivedPath), e);
        }
    }
}

