/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.approvej.scrub.Replacements;
import org.approvej.scrub.Scrubber;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RegexScrubber
implements Scrubber<String> {
    private final Pattern pattern;
    private Function<Integer, Object> replacement;

    RegexScrubber(Pattern pattern, Function<Integer, Object> replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public String apply(String unscrubbedValue) {
        Matcher matcher = this.pattern.matcher(unscrubbedValue);
        HashMap findings = new HashMap();
        Function<MatchResult, String> replacer = result -> {
            String group = result.group();
            findings.putIfAbsent(group, findings.size() + 1);
            return this.replacement.apply((Integer)findings.get(group)).toString();
        };
        return matcher.replaceAll(replacer);
    }

    public RegexScrubber replacement(Function<Integer, Object> replacement) {
        this.replacement = replacement;
        return this;
    }

    public RegexScrubber replacement(String staticReplacement) {
        this.replacement = Replacements.string(staticReplacement);
        return this;
    }
}

