/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.scrub;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.approvej.scrub.DateTimeScrubber;
import org.approvej.scrub.RegexScrubber;
import org.approvej.scrub.RelativeDateScrubber;
import org.approvej.scrub.Replacements;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Scrubbers {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");

    private Scrubbers() {
    }

    public static RegexScrubber stringsMatching(Pattern pattern) {
        return new RegexScrubber(pattern, Replacements.numbered());
    }

    public static RegexScrubber stringsMatching(String pattern) {
        return Scrubbers.stringsMatching(Pattern.compile(pattern));
    }

    public static RegexScrubber dateTimeFormat(String dateTimePattern, Locale locale) {
        return new DateTimeScrubber(dateTimePattern, locale, Replacements.numbered("datetime"));
    }

    public static RegexScrubber dateTimeFormat(String dateTimePattern) {
        return Scrubbers.dateTimeFormat(dateTimePattern, Locale.getDefault());
    }

    public static RegexScrubber isoLocalDates() {
        return Scrubbers.dateTimeFormat("yyyy-MM-dd").replacement(Replacements.numbered("isoLocalDate"));
    }

    public static RegexScrubber isoOffsetDates() {
        return Scrubbers.dateTimeFormat("yyyy-MM-ddXXX").replacement(Replacements.numbered("isoOffsetDate"));
    }

    public static RegexScrubber isoDates() {
        return Scrubbers.dateTimeFormat("yyyy-MM-dd[XXX]").replacement(Replacements.numbered("isoDate"));
    }

    public static RegexScrubber isoLocalTimes() {
        return Scrubbers.dateTimeFormat("HH:mm:ss[.S]").replacement(Replacements.numbered("isoLocalTime"));
    }

    public static RegexScrubber isoOffsetTimes() {
        return Scrubbers.dateTimeFormat("HH:mm:ss[.S]XXX").replacement(Replacements.numbered("isoOffsetTime"));
    }

    public static RegexScrubber isoTimes() {
        return Scrubbers.dateTimeFormat("HH:mm:ss[.S][XXX]").replacement(Replacements.numbered("isoTime"));
    }

    public static RegexScrubber isoLocalDateTimes() {
        return Scrubbers.dateTimeFormat("yyyy-MM-dd'T'HH:mm:ss[.S]").replacement(Replacements.numbered("isoLocalDateTime"));
    }

    public static RegexScrubber isoOffsetDateTimes() {
        return Scrubbers.dateTimeFormat("yyyy-MM-dd'T'HH:mm:ss[.S]XXX").replacement(Replacements.numbered("isoOffsetDateTime"));
    }

    public static RegexScrubber isoZonedDateTimes(Locale locale) {
        return Scrubbers.dateTimeFormat("yyyy-MM-dd'T'HH:mm:ss[.S]XXX'['VV']'", locale).replacement(Replacements.numbered("isoZonedDateTime"));
    }

    public static RegexScrubber isoZonedDateTimes() {
        return Scrubbers.isoZonedDateTimes(Locale.getDefault());
    }

    public static RegexScrubber isoDateTimes(Locale locale) {
        return Scrubbers.dateTimeFormat("yyyy-MM-dd'T'HH:mm:ss[.S][XXX['['VV']']]", locale).replacement(Replacements.numbered("isoDateTime"));
    }

    public static RegexScrubber isoDateTimes() {
        return Scrubbers.isoDateTimes(Locale.getDefault());
    }

    public static RegexScrubber isoOrdinalDates() {
        return Scrubbers.dateTimeFormat("yyyy-DDD[XXXX]").replacement(Replacements.numbered("isoOrdinalDate"));
    }

    public static RegexScrubber isoWeekDates() {
        return Scrubbers.dateTimeFormat("YYYY-'W'ww-e[XXXX]").replacement(Replacements.numbered("isoWeekDate"));
    }

    public static RegexScrubber isoInstants() {
        return Scrubbers.dateTimeFormat("uuuu-MM-dd'T'HH:mm:ss.SX").replacement(Replacements.numbered("isoInstant"));
    }

    public static RegexScrubber basicIsoDates() {
        return Scrubbers.dateTimeFormat("yyyyMMdd[X]").replacement(Replacements.numbered("basicIsoDate"));
    }

    public static RegexScrubber rfc1123DateTimes() {
        return Scrubbers.dateTimeFormat("EEE, d MMM yyyy HH:mm:ss O", Locale.US).replacement(Replacements.numbered("rfc1123DateTime"));
    }

    public static RegexScrubber uuids() {
        return Scrubbers.stringsMatching(UUID_PATTERN).replacement(Replacements.numbered("uuid"));
    }

    public static RelativeDateScrubber relativeDates(DateTimeFormatter dateFormatPattern) {
        return new RelativeDateScrubber(dateFormatPattern);
    }
}

