/*
 * Decompiled with CFR 0.152.
 */
package org.approvej;

import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.approvej.ApprovalError;
import org.approvej.ApprovalResult;
import org.approvej.Configuration;
import org.approvej.approve.Approvers;
import org.approvej.approve.FileApprover;
import org.approvej.approve.PathProvider;
import org.approvej.approve.PathProviderBuilder;
import org.approvej.print.Printer;
import org.approvej.review.FileReviewer;
import org.approvej.review.FileReviewerScript;
import org.approvej.review.ReviewResult;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ApprovalBuilder<T> {
    private T receivedValue;
    private String name;
    private final String filenameExtension;
    private @Nullable FileReviewer fileReviewer;

    private ApprovalBuilder(T originalValue, String name, String filenameExtension) {
        this.receivedValue = originalValue;
        this.name = name;
        this.filenameExtension = filenameExtension;
        this.fileReviewer = Configuration.configuration.defaultFileReviewer();
    }

    public static <T> ApprovalBuilder<T> approve(T originalValue) {
        return new ApprovalBuilder<T>(originalValue, "", "txt");
    }

    public ApprovalBuilder<T> named(String name) {
        this.name = name;
        return this;
    }

    public ApprovalBuilder<String> printWith(Function<T, String> printer) {
        return new ApprovalBuilder<String>(printer.apply(this.receivedValue), this.name, "txt");
    }

    public ApprovalBuilder<String> printWith(Printer<T> printer) {
        return new ApprovalBuilder<String>((String)printer.apply(this.receivedValue), this.name, printer.filenameExtension());
    }

    public ApprovalBuilder<String> print() {
        return this.printWith(Configuration.configuration.defaultPrinter());
    }

    public ApprovalBuilder<T> scrubbedOf(UnaryOperator<T> scrubber) {
        this.receivedValue = scrubber.apply(this.receivedValue);
        return this;
    }

    public ApprovalBuilder<T> reviewWith(FileReviewer reviewer) {
        this.fileReviewer = reviewer;
        return this;
    }

    public ApprovalBuilder<T> reviewWith(String script) {
        return this.reviewWith(FileReviewerScript.script(script));
    }

    public void by(Function<String, ApprovalResult> approver) {
        ApprovalResult result;
        if (!(this.receivedValue instanceof String)) {
            this.print().by(approver);
        }
        if ((result = approver.apply(String.valueOf(this.receivedValue))).needsApproval()) {
            throw new ApprovalError(result.received(), result.previouslyApproved());
        }
    }

    public void byValue(String previouslyApproved) {
        this.by(Approvers.value(previouslyApproved));
    }

    public void byFile(PathProvider pathProvider) {
        ReviewResult reviewResult;
        FileApprover approver = Approvers.file(pathProvider);
        ApprovalResult approvalResult = approver.apply(String.valueOf(this.receivedValue));
        if (approvalResult.needsApproval() && this.fileReviewer != null && (reviewResult = (ReviewResult)this.fileReviewer.apply(pathProvider)).needsReapproval()) {
            approvalResult = approver.apply(String.valueOf(this.receivedValue));
        }
        approvalResult.throwIfNotApproved();
    }

    public void byFile(PathProviderBuilder pathProviderBuilder) {
        if (!(this.receivedValue instanceof String)) {
            this.printWith(Configuration.configuration.defaultPrinter()).byFile(pathProviderBuilder);
        } else {
            this.byFile(pathProviderBuilder.filenameAffix(this.name).filenameExtension(this.filenameExtension));
        }
    }

    public void byFile() {
        this.byFile(PathProviderBuilder.nextToTest());
    }

    public void byFile(Path approvedPath) {
        this.byFile(PathProviderBuilder.approvedPath(approvedPath));
    }

    public void byFile(String approvedPath) {
        this.byFile(PathProviderBuilder.approvedPath(Path.of(approvedPath, new String[0])));
    }
}

