/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface TestMethod {
    public static Optional<TestMethod> create(Method method) {
        return Stream.of(new JUnitTestMethod(method), new TestNGTestMethod(method), new SpockTestMethod(method)).filter(testMethod -> !testMethod.testAnnotations().isEmpty()).findFirst();
    }

    public Method method();

    public String testCaseName();

    public Class<?> testClass();

    public List<Annotation> testAnnotations();

    public record JUnitTestMethod(Method method) implements TestMethod
    {
        @Override
        public String testCaseName() {
            return this.method.getName();
        }

        @Override
        public Class<?> testClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public List<Annotation> testAnnotations() {
            return Arrays.stream(this.method.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().getName().startsWith("org.junit.")).toList();
        }
    }

    public record TestNGTestMethod(Method method) implements TestMethod
    {
        @Override
        public String testCaseName() {
            return this.method.getName();
        }

        @Override
        public Class<?> testClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public List<Annotation> testAnnotations() {
            return Arrays.stream(this.method.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().getName().startsWith("org.testng.annotations.")).toList();
        }
    }

    public record SpockTestMethod(Method method) implements TestMethod
    {
        @Override
        public String testCaseName() {
            return this.testAnnotations().stream().filter(annotation -> annotation.annotationType().getName().equals("org.spockframework.runtime.model.FeatureMetadata")).findFirst().map(annotation -> {
                try {
                    return annotation.annotationType().getMethod("name", new Class[0]).invoke(annotation, new Object[0]).toString();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }).orElse(this.method.getName());
        }

        @Override
        public Class<?> testClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public List<Annotation> testAnnotations() {
            return Arrays.stream(this.method.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().getName().startsWith("org.spockframework.")).toList();
        }
    }
}

