/*
 * Decompiled with CFR 0.152.
 */
package org.approvej.approve;

import java.nio.file.Path;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.approvej.approve.PathProvider;
import org.approvej.approve.PathProviderRecord;
import org.approvej.approve.StackTraceTestFinderUtil;
import org.approvej.approve.TestMethod;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PathProviderBuilder {
    public static final String RECEIVED = "received";
    public static final String APPROVED = "approved";
    private final String baseFilename;
    private Path directory = Path.of(".", new String[0]);
    private String filenameAffix = "";

    public static PathProvider approvedPath(Path approvedPath) {
        Pattern approvedFilenamePattern = Pattern.compile("(?<baseFilename>.+?)(?<approved>[-_. ]approved)?(?:\\.(?<extension>[^.]*))?$");
        Path directory = approvedPath.getParent();
        String approvedFilename = approvedPath.getFileName().toString();
        Matcher matcher = approvedFilenamePattern.matcher(approvedFilename);
        String baseFilename = matcher.matches() ? matcher.group("baseFilename") : approvedFilename;
        String filenameExtension = matcher.matches() ? Objects.requireNonNullElse(matcher.group("extension"), "txt") : "txt";
        String receivedFilename = "%s-%s.%s".formatted(baseFilename, RECEIVED, filenameExtension);
        return new PathProviderRecord(directory, approvedFilename, receivedFilename);
    }

    public static PathProvider approvedPath(String approvedPathString) {
        return PathProviderBuilder.approvedPath(Path.of(approvedPathString, new String[0]));
    }

    public static PathProviderBuilder nextToTest() {
        TestMethod testMethod = StackTraceTestFinderUtil.currentTestMethod();
        return new PathProviderBuilder("%s-%s".formatted(testMethod.testClass().getSimpleName(), testMethod.testCaseName())).directory(StackTraceTestFinderUtil.findTestSourcePath(testMethod.method()).getParent());
    }

    public static PathProviderBuilder nextToTestInSubdirectory() {
        TestMethod testMethod = StackTraceTestFinderUtil.currentTestMethod();
        return new PathProviderBuilder("%s".formatted(testMethod.testCaseName())).directory(StackTraceTestFinderUtil.findTestSourcePath(testMethod.method()).getParent().resolve(testMethod.testClass().getSimpleName()));
    }

    private PathProviderBuilder(String baseFilename) {
        this.baseFilename = baseFilename;
    }

    public PathProviderBuilder directory(Path directory) {
        this.directory = directory;
        return this;
    }

    public PathProviderBuilder filenameAffix(String filenameAffix) {
        this.filenameAffix = !filenameAffix.isBlank() && !filenameAffix.startsWith("-") ? "-%s".formatted(filenameAffix) : filenameAffix;
        return this;
    }

    public PathProvider filenameExtension(String filenameExtension) {
        return new PathProviderRecord(this.directory, "%s%s-%s.%s".formatted(this.baseFilename, this.filenameAffix, APPROVED, filenameExtension), "%s%s-%s.%s".formatted(this.baseFilename, this.filenameAffix, RECEIVED, filenameExtension));
    }
}

