/*
 * Decompiled with CFR 0.152.
 */
package org.araqnid.hamkrest.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.natpryce.hamkrest.MatchResult;
import com.natpryce.hamkrest.Matcher;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.araqnid.hamkrest.json.EquivalenceMatchersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u001a.\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\n0\u000e\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\n0\u000e\u001aM\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\f2\u0006\u0010\u0007\u001a\u0002H\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\n0\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\u0002\u0010\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0003*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"strictMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "userInputMapper", "kotlin.jvm.PlatformType", "bytesEquivalentTo", "Lcom/natpryce/hamkrest/Matcher;", "", "expectedJsonSource", "", "equivalentJsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "equivalentTo", "Actual", "jsonParser", "Lkotlin/Function1;", "jsonRepresentationEquivalentTo", "Expected", "expectedJsonParser", "actualJsonParser", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lcom/natpryce/hamkrest/Matcher;", "hamkrest-json"})
public final class EquivalenceMatchersKt {
    private static final ObjectMapper strictMapper = new ObjectMapper();
    private static final ObjectMapper userInputMapper = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});

    @NotNull
    public static final Matcher<JsonNode> equivalentJsonNode(@NotNull String expectedJsonSource) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<String, JsonNode>(userInputMapper){

            public final JsonNode invoke(String p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree(Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, equivalentJsonNode.2.INSTANCE);
    }

    @NotNull
    public static final Matcher<String> equivalentTo(@NotNull String expectedJsonSource) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<String, JsonNode>(userInputMapper){

            public final JsonNode invoke(String p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree(Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, (Function1)new Function1<String, JsonNode>(strictMapper){

            public final JsonNode invoke(String p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree(Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        });
    }

    @NotNull
    public static final Matcher<String> equivalentTo(@NotNull byte[] expectedJsonSource) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<byte[], JsonNode>(userInputMapper){

            public final JsonNode invoke(byte[] p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree([B)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, (Function1)new Function1<String, JsonNode>(strictMapper){

            public final JsonNode invoke(String p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree(Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        });
    }

    @NotNull
    public static final Matcher<byte[]> bytesEquivalentTo(@NotNull String expectedJsonSource) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<String, JsonNode>(userInputMapper){

            public final JsonNode invoke(String p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree(Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, (Function1)new Function1<byte[], JsonNode>(strictMapper){

            public final JsonNode invoke(byte[] p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree([B)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        });
    }

    @NotNull
    public static final Matcher<byte[]> bytesEquivalentTo(@NotNull byte[] expectedJsonSource) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<byte[], JsonNode>(userInputMapper){

            public final JsonNode invoke(byte[] p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree([B)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, (Function1)new Function1<byte[], JsonNode>(strictMapper){

            public final JsonNode invoke(byte[] p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree([B)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        });
    }

    @NotNull
    public static final <Actual> Matcher<Actual> equivalentTo(@NotNull String expectedJsonSource, @NotNull Function1<? super Actual, ? extends JsonNode> jsonParser) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        Intrinsics.checkParameterIsNotNull(jsonParser, (String)"jsonParser");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<String, JsonNode>(userInputMapper){

            public final JsonNode invoke(String p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree(Ljava/lang/String;)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, jsonParser);
    }

    @NotNull
    public static final <Actual> Matcher<Actual> equivalentTo(@NotNull byte[] expectedJsonSource, @NotNull Function1<? super Actual, ? extends JsonNode> jsonParser) {
        Intrinsics.checkParameterIsNotNull((Object)expectedJsonSource, (String)"expectedJsonSource");
        Intrinsics.checkParameterIsNotNull(jsonParser, (String)"jsonParser");
        return EquivalenceMatchersKt.jsonRepresentationEquivalentTo(expectedJsonSource, (Function1)new Function1<byte[], JsonNode>(userInputMapper){

            public final JsonNode invoke(byte[] p1) {
                return ((ObjectMapper)this.receiver).readTree(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ObjectMapper.class);
            }

            public final String getName() {
                return "readTree";
            }

            public final String getSignature() {
                return "readTree([B)Lcom/fasterxml/jackson/databind/JsonNode;";
            }
        }, jsonParser);
    }

    @NotNull
    public static final <Expected, Actual> Matcher<Actual> jsonRepresentationEquivalentTo(Expected expectedJsonSource, @NotNull Function1<? super Expected, ? extends JsonNode> expectedJsonParser, @NotNull Function1<? super Actual, ? extends JsonNode> actualJsonParser) {
        JsonNode jsonNode;
        Intrinsics.checkParameterIsNotNull(expectedJsonParser, (String)"expectedJsonParser");
        Intrinsics.checkParameterIsNotNull(actualJsonParser, (String)"actualJsonParser");
        try {
            jsonNode = (JsonNode)expectedJsonParser.invoke(expectedJsonSource);
        }
        catch (IOException e) {
            throw (Throwable)new IllegalArgumentException("Invalid reference JSON", e);
        }
        JsonNode expectedJson = jsonNode;
        return (Matcher)new Matcher.Primitive<Actual>(actualJsonParser, expectedJson, expectedJsonSource){
            final /* synthetic */ Function1 $actualJsonParser;
            final /* synthetic */ JsonNode $expectedJson;
            final /* synthetic */ Object $expectedJsonSource;

            @NotNull
            public MatchResult invoke(Actual actual) {
                JsonNode jsonNode;
                try {
                    jsonNode = (JsonNode)this.$actualJsonParser.invoke(actual);
                }
                catch (IOException e) {
                    return (MatchResult)new MatchResult.Mismatch("Invalid JSON: " + e);
                }
                JsonNode actualJson = jsonNode;
                return Intrinsics.areEqual((Object)this.$expectedJson, (Object)actualJson) ? (MatchResult)MatchResult.Match.INSTANCE : (MatchResult)new MatchResult.Mismatch(String.valueOf(actualJson));
            }

            @NotNull
            public String getDescription() {
                return "JSON " + this.$expectedJsonSource;
            }
            {
                this.$actualJsonParser = $captured_local_variable$0;
                this.$expectedJson = $captured_local_variable$1;
                this.$expectedJsonSource = $captured_local_variable$2;
            }
        };
    }
}

