/*
 * Decompiled with CFR 0.152.
 */
package org.araqnid.hamkrest.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.natpryce.hamkrest.DescribeKt;
import com.natpryce.hamkrest.MatchResult;
import com.natpryce.hamkrest.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.araqnid.hamkrest.json.EquivalenceMatchersKt;
import org.araqnid.hamkrest.json.StructureMatchersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u0000J&\u0010\u0011\u001a\u00020\u0000\"\b\b\u0000\u0010\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0006J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u001aJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/araqnid/hamkrest/json/ObjectNodeMatcher;", "Lcom/natpryce/hamkrest/Matcher$Primitive;", "Lcom/fasterxml/jackson/databind/JsonNode;", "propertyMatchers", "", "", "Lcom/natpryce/hamkrest/Matcher;", "failOnUnexpectedProperties", "", "(Ljava/util/Map;Z)V", "description", "getDescription", "()Ljava/lang/String;", "invoke", "Lcom/natpryce/hamkrest/MatchResult;", "actual", "withAnyOtherProperties", "withProperty", "N", "key", "matcher", "b", "x", "", "n", "", "", "str", "withPropertyJSON", "json", "hamkrest-json"})
public final class ObjectNodeMatcher
extends Matcher.Primitive<JsonNode> {
    private final Map<String, Matcher<JsonNode>> propertyMatchers;
    private final boolean failOnUnexpectedProperties;

    @NotNull
    public MatchResult invoke(@NotNull JsonNode actual) {
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        if (!(actual instanceof ObjectNode)) {
            return (MatchResult)new MatchResult.Mismatch("not an object node: " + actual);
        }
        Iterator iterator = actual.fieldNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"actual.fieldNames()");
        Set remainingFieldNames = SequencesKt.toMutableSet((Sequence)SequencesKt.asSequence((Iterator)iterator));
        Iterable $this$forEach$iv = this.propertyMatchers.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode value;
            Map.Entry $dstr$name$matcher = (Map.Entry)element$iv;
            boolean bl = false;
            Map.Entry entry = $dstr$name$matcher;
            boolean bl2 = false;
            String name = (String)entry.getKey();
            entry = $dstr$name$matcher;
            bl2 = false;
            Matcher matcher = (Matcher)entry.getValue();
            if (!actual.has(name)) {
                return (MatchResult)new MatchResult.Mismatch(name + " was not present");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)actual.get(name), (String)"actual.get(name)");
            MatchResult result = matcher.invoke((Object)value);
            if (Intrinsics.areEqual((Object)result, (Object)MatchResult.Match.INSTANCE) ^ true) {
                return StructureMatchersKt.access$prefixedWith(result, name + ": ");
            }
            remainingFieldNames.remove(name);
        }
        if (this.failOnUnexpectedProperties) {
            Collection collection = remainingFieldNames;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return (MatchResult)new MatchResult.Mismatch("unexpected properties: " + remainingFieldNames);
            }
        }
        return (MatchResult)MatchResult.Match.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getDescription() {
        boolean bl = false;
        List parts = new ArrayList();
        Map<String, Matcher<JsonNode>> $this$mapTo$iv = this.propertyMatchers;
        boolean $i$f$mapTo = false;
        Map<String, Matcher<JsonNode>> map = $this$mapTo$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<String, Matcher<JsonNode>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$key$value;
            Map.Entry<String, Matcher<JsonNode>> item$iv;
            Map.Entry<String, Matcher<JsonNode>> entry = item$iv = iterator.next();
            Collection collection = parts;
            boolean bl3 = false;
            void var10_13 = $dstr$key$value;
            boolean bl4 = false;
            String key = (String)var10_13.getKey();
            var10_13 = $dstr$key$value;
            bl4 = false;
            Matcher value = (Matcher)var10_13.getValue();
            String string = key + ": " + DescribeKt.describe((Object)value);
            collection.add(string);
        }
        if (this.failOnUnexpectedProperties) {
            Collection collection = parts;
            String string = "/* others */";
            boolean bl5 = false;
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public final ObjectNodeMatcher withAnyOtherProperties() {
        return new ObjectNodeMatcher(this.propertyMatchers, false);
    }

    @NotNull
    public final <N extends JsonNode> ObjectNodeMatcher withProperty(@NotNull String key, @NotNull Matcher<? super N> matcher) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
        boolean bl = !this.propertyMatchers.containsKey(key);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Property '" + key + "' is specified multiple times";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new ObjectNodeMatcher(MapsKt.plus(this.propertyMatchers, (Pair)TuplesKt.to((Object)key, matcher)), this.failOnUnexpectedProperties);
    }

    @NotNull
    public final ObjectNodeMatcher withProperty(@NotNull String key, int n) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.withProperty(key, StructureMatchersKt.jsonInt(n));
    }

    @NotNull
    public final ObjectNodeMatcher withProperty(@NotNull String key, long n) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.withProperty(key, StructureMatchersKt.jsonLong(n));
    }

    @NotNull
    public final ObjectNodeMatcher withProperty(@NotNull String key, double x) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.withProperty(key, StructureMatchersKt.jsonDouble(x));
    }

    @NotNull
    public final ObjectNodeMatcher withProperty(@NotNull String key, boolean b) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.withProperty(key, StructureMatchersKt.jsonBoolean(b));
    }

    @NotNull
    public final ObjectNodeMatcher withProperty(@NotNull String key, @NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        return this.withProperty(key, StructureMatchersKt.jsonString(str));
    }

    @NotNull
    public final ObjectNodeMatcher withPropertyJSON(@NotNull String key, @NotNull String json2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)json2, (String)"json");
        return this.withProperty(key, EquivalenceMatchersKt.equivalentJsonNode(json2));
    }

    public ObjectNodeMatcher(@NotNull Map<String, ? extends Matcher<? super JsonNode>> propertyMatchers, boolean failOnUnexpectedProperties) {
        Intrinsics.checkParameterIsNotNull(propertyMatchers, (String)"propertyMatchers");
        this.propertyMatchers = propertyMatchers;
        this.failOnUnexpectedProperties = failOnUnexpectedProperties;
    }

    public /* synthetic */ ObjectNodeMatcher(Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(map, bl);
    }

    public ObjectNodeMatcher() {
        this(null, false, 3, null);
    }
}

