(function (_, Kotlin) {
  'use strict';
  var equals = Kotlin.equals;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var substring = Kotlin.kotlin.text.substring_fc3b62$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var joinTo = Kotlin.kotlin.collections.joinTo_gcc71v$;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init;
  var Any = Object;
  var throwCCE = Kotlin.throwCCE;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var unboxChar = Kotlin.unboxChar;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var trimStart = Kotlin.kotlin.text.trimStart_gw00vp$;
  var toBoolean = Kotlin.kotlin.text.toBoolean_5cw0du$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var print = Kotlin.kotlin.io.print_s8jyv4$;
  ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$OptionProvider.prototype);
  ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral;
  ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$OptionProvider.prototype);
  ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral;
  ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$OptionProvider.prototype);
  ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral;
  ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$OptionProvider.prototype);
  ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral;
  ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$ArgumentProvider.prototype);
  ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral;
  ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$ArgumentProvider.prototype);
  ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral;
  ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$ArgumentProvider.prototype);
  ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral;
  ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$ArgumentProvider.prototype);
  ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral;
  ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype = Object.create(ArgParser$ArgumentProvider.prototype);
  ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype.constructor = ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral;
  ArgParser_init$ObjectLiteral.prototype = Object.create(ArgParser$OptionProvider.prototype);
  ArgParser_init$ObjectLiteral.prototype.constructor = ArgParser_init$ObjectLiteral;
  function ArgParser(appName) {
    ArgParser$Companion_getInstance();
    this.appName_0 = appName;
    this.optionsByName_0 = LinkedHashMap_init();
    this.optionsByShortName_0 = LinkedHashMap_init();
    this.arguments_0 = ArrayList_init();
    this.helpNeeded_pjsikm$_0 = false;
    var help = new ArgParser_init$ObjectLiteral(this, ArgType$Companion_getInstance().BOOLEAN, 'h', 'help', 'Provide syntax summary');
    this.register_0(help);
  }
  Object.defineProperty(ArgParser.prototype, 'helpNeeded', {
    configurable: true,
    get: function () {
      return this.helpNeeded_pjsikm$_0;
    },
    set: function (helpNeeded) {
      this.helpNeeded_pjsikm$_0 = helpNeeded;
    }
  });
  ArgParser.prototype.parse_upaayv$ = function (args) {
    var tmp$, tmp$_0, tmp$_1;
    var inputIterator = args.iterator();
    var inArgumentList = false;
    var currentArgument = 0;
    while (inputIterator.hasNext()) {
      var inputString = inputIterator.next();
      if (equals(inputString, '--')) {
        inArgumentList = true;
      } else if (!inArgumentList) {
        if (startsWith(inputString, '--')) {
          var valueSeparator = indexOf(inputString, 61);
          if (valueSeparator < 0) {
            var optionName = inputString.substring(2);
            var tmp$_2;
            if ((tmp$ = this.optionsByName_0.get_11rb$(optionName)) != null)
              tmp$_2 = tmp$;
            else {
              throw IllegalStateException_init(("Unknown option '--" + optionName + "'").toString());
            }
            var option = tmp$_2;
            if (option.argType.needsArgument) {
              option.acceptArg_61zpoe$(inputIterator.next());
            } else {
              option.acceptArg_61zpoe$('');
            }
          } else {
            var optionName_0 = substring(inputString, until(2, valueSeparator));
            var tmp$_3;
            if ((tmp$_0 = this.optionsByName_0.get_11rb$(optionName_0)) != null)
              tmp$_3 = tmp$_0;
            else {
              throw IllegalStateException_init(("Unknown option '--" + optionName_0 + "'").toString());
            }
            var option_0 = tmp$_3;
            var startIndex = valueSeparator + 1 | 0;
            option_0.acceptArg_61zpoe$(inputString.substring(startIndex));
          }
          continue;
        } else if (startsWith(inputString, '-')) {
          var firstOption = this.findOption_0(String.fromCharCode(inputString.charCodeAt(1)));
          if (firstOption.argType.needsArgument) {
            if (inputString.length === 2) {
              var arg = inputIterator.next();
              firstOption.acceptArg_61zpoe$(arg);
            } else {
              var arg_0 = inputString.substring(2);
              firstOption.acceptArg_61zpoe$(arg_0);
            }
          } else {
            tmp$_1 = inputString.length;
            for (var i = 1; i < tmp$_1; i++) {
              var provider = this.findOption_0(String.fromCharCode(inputString.charCodeAt(i)));
              if (provider.argType.needsArgument) {
                throw IllegalStateException_init(("Option '" + provider.name + "' needs an argument").toString());
              }provider.acceptArg_61zpoe$('');
            }
          }
          continue;
        }} else {
        inArgumentList = true;
      }
      if (!(currentArgument < this.arguments_0.size)) {
        var message = 'Unexpected trailing argument: ' + inputString;
        throw IllegalStateException_init(message.toString());
      }var provider_0 = this.arguments_0.get_za3lpa$(currentArgument);
      provider_0.acceptArg_61zpoe$(inputString);
      if (!provider_0.multiple) {
        currentArgument = currentArgument + 1 | 0;
      }}
  };
  ArgParser.prototype.buildSyntax = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0;
    var seenGroups = LinkedHashSet_init();
    tmp$ = this.optionsByName_0.values.iterator();
    while (tmp$.hasNext()) {
      var option = tmp$.next();
      if (!seenGroups.add_11rb$(option.group))
        continue;
      $receiver.append_s8itvh$(32);
      option.appendSyntaxSummary_4n11c8$($receiver);
    }
    tmp$_0 = this.arguments_0.iterator();
    while (tmp$_0.hasNext()) {
      var argument = tmp$_0.next();
      if (argument.multiple && argument.optional)
        $receiver.append_pdl1vj$(' [' + argument.name + '...]');
      else if (argument.multiple)
        $receiver.append_pdl1vj$(' ' + argument.name + '...');
      else if (argument.optional)
        $receiver.append_pdl1vj$(' [' + argument.name + ']');
      else {
        $receiver.append_pdl1vj$(' ' + argument.name);
      }
    }
    var $receiver_0 = $receiver.toString();
    var tmp$_1;
    return trimStart(Kotlin.isCharSequence(tmp$_1 = $receiver_0) ? tmp$_1 : throwCCE()).toString();
  };
  ArgParser.prototype.register_0 = function (provider) {
    if (!(this.optionsByName_0.get_11rb$(provider.longName) == null)) {
      var message = "Option '--" + provider.longName + "' already registered";
      throw IllegalStateException_init(message.toString());
    }if (!(this.optionsByShortName_0.get_11rb$(provider.shortName) == null)) {
      var message_0 = "Option '-" + provider.shortName + "' already registered";
      throw IllegalStateException_init(message_0.toString());
    }var $receiver = this.optionsByName_0;
    var key = provider.longName;
    $receiver.put_xwzc9p$(key, provider);
    var $receiver_0 = this.optionsByShortName_0;
    var key_0 = provider.shortName;
    $receiver_0.put_xwzc9p$(key_0, provider);
  };
  ArgParser.prototype.register_1 = function (provider) {
    this.arguments_0.add_11rb$(provider);
  };
  ArgParser.prototype.findOption_0 = function (shortName) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.optionsByShortName_0.get_11rb$(shortName)) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init(('Unknown option: -' + shortName).toString());
    }
    return tmp$_0;
  };
  ArgParser.prototype.option_3m7cvo$ = function (type, shortName, description) {
    return new ArgParser$OptionalSingleOptionDefinition(this, type, shortName, description);
  };
  ArgParser.prototype.optionGroup_n26fge$ = function (type, options) {
    return new ArgParser$OptionGroupDefinition(this, type, toList(options));
  };
  ArgParser.prototype.argument_fwsu1q$ = function (type, description) {
    return new ArgParser$MandatoryArgumentDefinition(this, type, description);
  };
  function ArgParser$OptionProvider(argType, shortName, name, description, group) {
    if (group === void 0)
      group = name;
    this.argType = argType;
    this.shortName = shortName;
    this.name = name;
    this.description = description;
    this.group = group;
    this.longName = ArgParser$Companion_getInstance().camelCaseToDashes_omtdrb$(this.name);
  }
  ArgParser$OptionProvider.prototype.getValue_n5byny$ = function (owner, property) {
    return this.produce();
  };
  ArgParser$OptionProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionProvider',
    interfaces: []
  };
  function ArgParser$ArgumentProvider(argType, name, description, multiple, optional) {
    this.argType = argType;
    this.name = name;
    this.description = description;
    this.multiple = multiple;
    this.optional = optional;
  }
  ArgParser$ArgumentProvider.prototype.getValue_n5byny$ = function (owner, property) {
    return this.produce();
  };
  ArgParser$ArgumentProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ArgumentProvider',
    interfaces: []
  };
  function ArgParser$DefaultedSingleOptionDefinition($outer, argType, shortName, description, defaultProvider) {
    this.$outer = $outer;
    this.argType = argType;
    this.shortName = shortName;
    this.description = description;
    this.defaultProvider = defaultProvider;
  }
  function ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral(this$DefaultedSingleOptionDefinition, argType, shortName, name, description, group) {
    this.this$DefaultedSingleOptionDefinition = this$DefaultedSingleOptionDefinition;
    ArgParser$OptionProvider.call(this, argType, shortName, name, description, group);
    this.value = null;
    this.specified = false;
  }
  ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    if (this.specified) {
      throw IllegalStateException_init(("Option '" + this.name + "' has already been specified").toString());
    }this.value = this.argType.read_61zpoe$(arg);
  };
  ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.appendSyntaxSummary_4n11c8$ = function (output) {
    output.append_gw00v9$('');
  };
  ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    var tmp$;
    return (tmp$ = this.value) != null ? tmp$ : this.this$DefaultedSingleOptionDefinition.defaultProvider();
  };
  ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$OptionProvider]
  };
  ArgParser$DefaultedSingleOptionDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$DefaultedSingleOptionDefinition$provideDelegate$ObjectLiteral(this, this.argType, this.shortName, property.callableName, this.description);
    this.$outer.register_0(provider);
    return provider;
  };
  ArgParser$DefaultedSingleOptionDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultedSingleOptionDefinition',
    interfaces: []
  };
  function ArgParser$OptionalSingleOptionDefinition($outer, argType, shortName, description) {
    this.$outer = $outer;
    this.argType = argType;
    this.shortName = shortName;
    this.description = description;
  }
  function ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral(argType, shortName, name, description, group) {
    ArgParser$OptionProvider.call(this, argType, shortName, name, description, group);
    this.value = null;
    this.specified = false;
  }
  ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    if (this.specified) {
      throw IllegalStateException_init(("Option '" + this.name + "' has already been specified").toString());
    }this.value = this.argType.read_61zpoe$(arg);
  };
  ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.appendSyntaxSummary_4n11c8$ = function (output) {
    output.append_gw00v9$('[ -');
    output.append_gw00v9$(this.shortName);
    if (this.argType.needsArgument)
      output.append_gw00v9$(' <' + this.name + '>');
    output.append_gw00v9$(' | --');
    output.append_gw00v9$(this.longName);
    if (this.argType.needsArgument)
      output.append_gw00v9$('=<value>');
    output.append_gw00v9$(' ]');
  };
  ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    return this.value;
  };
  ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$OptionProvider]
  };
  ArgParser$OptionalSingleOptionDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$OptionalSingleOptionDefinition$provideDelegate$ObjectLiteral(this.argType, this.shortName, property.callableName, this.description);
    this.$outer.register_0(provider);
    return provider;
  };
  function ArgParser$OptionalSingleOptionDefinition$default$lambda(closure$defaultValue) {
    return function () {
      return closure$defaultValue;
    };
  }
  ArgParser$OptionalSingleOptionDefinition.prototype.default_11rb$ = function (defaultValue) {
    return new ArgParser$DefaultedSingleOptionDefinition(this.$outer, this.argType, this.shortName, this.description, ArgParser$OptionalSingleOptionDefinition$default$lambda(defaultValue));
  };
  ArgParser$OptionalSingleOptionDefinition.prototype.default_skz6lt$ = function (defaultProvider) {
    return new ArgParser$DefaultedSingleOptionDefinition(this.$outer, this.argType, this.shortName, this.description, defaultProvider);
  };
  ArgParser$OptionalSingleOptionDefinition.prototype.multiple = function () {
    return new ArgParser$MultipleOptionDefinition(this.$outer, this.argType, this.shortName, this.description);
  };
  ArgParser$OptionalSingleOptionDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionalSingleOptionDefinition',
    interfaces: []
  };
  function ArgParser$MultipleOptionDefinition($outer, argType, shortName, description) {
    this.$outer = $outer;
    this.argType = argType;
    this.shortName = shortName;
    this.description = description;
  }
  function ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral(argType, shortName, name, description, group) {
    ArgParser$OptionProvider.call(this, argType, shortName, name, description, group);
    this.values = ArrayList_init();
  }
  ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    var $receiver = this.values;
    var element = this.argType.read_61zpoe$(arg);
    $receiver.add_11rb$(element);
  };
  ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral.prototype.appendSyntaxSummary_4n11c8$ = function (output) {
    output.append_gw00v9$('[ -');
    output.append_gw00v9$(this.shortName);
    if (this.argType.needsArgument)
      output.append_gw00v9$(' <' + this.name + '>');
    output.append_gw00v9$(' | --');
    output.append_gw00v9$(this.longName);
    if (this.argType.needsArgument)
      output.append_gw00v9$('=<value>');
    output.append_gw00v9$(' ]...');
  };
  ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    return this.values;
  };
  ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$OptionProvider]
  };
  ArgParser$MultipleOptionDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$MultipleOptionDefinition$provideDelegate$ObjectLiteral(this.argType, this.shortName, property.callableName, this.description);
    this.$outer.register_0(provider);
    return provider;
  };
  ArgParser$MultipleOptionDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultipleOptionDefinition',
    interfaces: []
  };
  function ArgParser$GroupCollector(values) {
    this.values_0 = values;
  }
  ArgParser$GroupCollector.prototype.getValue_n5byny$ = function (owner, property) {
    return this.values_0;
  };
  ArgParser$GroupCollector.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GroupCollector',
    interfaces: []
  };
  function ArgParser$OptionGroupDefinition($outer, argType, options) {
    this.$outer = $outer;
    this.argType = argType;
    this.options = options;
  }
  function ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral(closure$values, closure$name, this$OptionGroupDefinition, argType, shortName, name, description, group) {
    this.closure$values = closure$values;
    this.closure$name = closure$name;
    this.this$OptionGroupDefinition = this$OptionGroupDefinition;
    ArgParser$OptionProvider.call(this, argType, shortName, name, description, group);
  }
  ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    var $receiver = this.closure$values;
    var element = to(this.closure$name, this.argType.read_61zpoe$(arg));
    $receiver.add_11rb$(element);
  };
  function ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral$appendSyntaxSummary$lambda$lambda(it) {
    return '-' + it.second + ' | --' + it.first;
  }
  ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral.prototype.appendSyntaxSummary_4n11c8$ = function (output) {
    this.this$OptionGroupDefinition;
    joinTo(this.this$OptionGroupDefinition.options, output, ' | ', '[ ', ' ]...', void 0, void 0, ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral$appendSyntaxSummary$lambda$lambda);
  };
  ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    throw UnsupportedOperationException_init();
  };
  ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$OptionProvider]
  };
  ArgParser$OptionGroupDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var tmp$;
    var values = ArrayList_init();
    tmp$ = this.options.iterator();
    while (tmp$.hasNext()) {
      var tmp$_0 = tmp$.next();
      var name = tmp$_0.component1()
      , shortName = tmp$_0.component2();
      this.$outer.register_0(new ArgParser$OptionGroupDefinition$provideDelegate$ObjectLiteral(values, name, this, this.argType, shortName, name, 'description for ' + name, this.options.get_za3lpa$(0).first));
    }
    return new ArgParser$GroupCollector(values);
  };
  ArgParser$OptionGroupDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionGroupDefinition',
    interfaces: []
  };
  function ArgParser$MandatoryArgumentDefinition($outer, argType, description) {
    this.$outer = $outer;
    this.argType = argType;
    this.description = description;
  }
  function ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral(argType, name, description, multiple, optional) {
    ArgParser$ArgumentProvider.call(this, argType, name, description, multiple, optional);
    this.value = null;
    this.specified = false;
  }
  ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    if (this.specified) {
      throw IllegalStateException_init(("Argument '" + this.name + "' has already been specified").toString());
    }this.value = this.argType.read_61zpoe$(arg);
    this.specified = true;
  };
  ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    var tmp$;
    var tmp$_0;
    if (this.specified)
      tmp$_0 = (tmp$ = this.value) == null || Kotlin.isType(tmp$, Any) ? tmp$ : throwCCE();
    else {
      throw IllegalStateException_init(("Argument '" + this.name + "' has not been specified").toString());
    }
    return tmp$_0;
  };
  ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$ArgumentProvider]
  };
  ArgParser$MandatoryArgumentDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$MandatoryArgumentDefinition$provideDelegate$ObjectLiteral(this.argType, property.callableName, this.description, false, false);
    this.$outer.register_1(provider);
    return provider;
  };
  ArgParser$MandatoryArgumentDefinition.prototype.optional = function () {
    return new ArgParser$OptionalArgumentDefinition(this.$outer, this.argType, this.description);
  };
  function ArgParser$MandatoryArgumentDefinition$default$lambda(closure$defaultValue) {
    return function () {
      return closure$defaultValue;
    };
  }
  ArgParser$MandatoryArgumentDefinition.prototype.default_11rb$ = function (defaultValue) {
    return new ArgParser$DefaultedArgumentDefinition(this.$outer, this.argType, this.description, ArgParser$MandatoryArgumentDefinition$default$lambda(defaultValue));
  };
  ArgParser$MandatoryArgumentDefinition.prototype.default_skz6lt$ = function (defaultProvider) {
    return new ArgParser$DefaultedArgumentDefinition(this.$outer, this.argType, this.description, defaultProvider);
  };
  ArgParser$MandatoryArgumentDefinition.prototype.vararg = function () {
    return new ArgParser$MandatoryVarargArgumentDefinition(this.$outer, this.argType, this.description);
  };
  ArgParser$MandatoryArgumentDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MandatoryArgumentDefinition',
    interfaces: []
  };
  function ArgParser$DefaultedArgumentDefinition($outer, argType, description, defaultProvider) {
    this.$outer = $outer;
    this.argType = argType;
    this.description = description;
    this.defaultProvider = defaultProvider;
  }
  function ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral(this$DefaultedArgumentDefinition, argType, name, description, multiple, optional) {
    this.this$DefaultedArgumentDefinition = this$DefaultedArgumentDefinition;
    ArgParser$ArgumentProvider.call(this, argType, name, description, multiple, optional);
    this.value = null;
    this.specified = false;
  }
  ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    if (this.specified) {
      throw IllegalStateException_init(("Argument '" + this.name + "' has already been specified").toString());
    }this.value = this.argType.read_61zpoe$(arg);
    this.specified = true;
  };
  ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    var tmp$;
    return this.specified ? (tmp$ = this.value) == null || Kotlin.isType(tmp$, Any) ? tmp$ : throwCCE() : this.this$DefaultedArgumentDefinition.defaultProvider();
  };
  ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$ArgumentProvider]
  };
  ArgParser$DefaultedArgumentDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$DefaultedArgumentDefinition$provideDelegate$ObjectLiteral(this, this.argType, property.callableName, this.description, false, true);
    this.$outer.register_1(provider);
    return provider;
  };
  ArgParser$DefaultedArgumentDefinition.prototype.optional = function () {
    return new ArgParser$OptionalArgumentDefinition(this.$outer, this.argType, this.description);
  };
  ArgParser$DefaultedArgumentDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultedArgumentDefinition',
    interfaces: []
  };
  function ArgParser$OptionalArgumentDefinition($outer, argType, description) {
    this.$outer = $outer;
    this.argType = argType;
    this.description = description;
  }
  function ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral(argType, name, description, multiple, optional) {
    ArgParser$ArgumentProvider.call(this, argType, name, description, multiple, optional);
    this.value = null;
    this.specified = false;
  }
  ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    if (this.specified) {
      throw IllegalStateException_init(("Argument '" + this.name + "' has already been specified").toString());
    }this.value = this.argType.read_61zpoe$(arg);
    this.specified = true;
  };
  ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    return this.value;
  };
  ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$ArgumentProvider]
  };
  ArgParser$OptionalArgumentDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$OptionalArgumentDefinition$provideDelegate$ObjectLiteral(this.argType, property.callableName, this.description, false, true);
    this.$outer.register_1(provider);
    return provider;
  };
  ArgParser$OptionalArgumentDefinition.prototype.vararg = function () {
    return new ArgParser$OptionalVarargArgumentDefinition(this.$outer, this.argType, this.description);
  };
  ArgParser$OptionalArgumentDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionalArgumentDefinition',
    interfaces: []
  };
  function ArgParser$MandatoryVarargArgumentDefinition($outer, argType, description) {
    this.$outer = $outer;
    this.argType = argType;
    this.description = description;
  }
  function ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral(argType, name, description, multiple, optional) {
    ArgParser$ArgumentProvider.call(this, argType, name, description, multiple, optional);
    this.values = ArrayList_init();
  }
  ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    var $receiver = this.values;
    var element = this.argType.read_61zpoe$(arg);
    $receiver.add_11rb$(element);
  };
  ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    var tmp$;
    if (!this.values.isEmpty())
      tmp$ = this.values;
    else {
      throw IllegalStateException_init(("No values specified for '" + this.name + "'").toString());
    }
    return tmp$;
  };
  ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$ArgumentProvider]
  };
  ArgParser$MandatoryVarargArgumentDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$MandatoryVarargArgumentDefinition$provideDelegate$ObjectLiteral(this.argType, property.callableName, this.description, true, false);
    this.$outer.register_1(provider);
    return provider;
  };
  ArgParser$MandatoryVarargArgumentDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MandatoryVarargArgumentDefinition',
    interfaces: []
  };
  function ArgParser$OptionalVarargArgumentDefinition($outer, argType, description) {
    this.$outer = $outer;
    this.argType = argType;
    this.description = description;
  }
  function ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral(argType, name, description, multiple, optional) {
    ArgParser$ArgumentProvider.call(this, argType, name, description, multiple, optional);
    this.values = ArrayList_init();
  }
  ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    var $receiver = this.values;
    var element = this.argType.read_61zpoe$(arg);
    $receiver.add_11rb$(element);
  };
  ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral.prototype.produce = function () {
    return this.values;
  };
  ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$ArgumentProvider]
  };
  ArgParser$OptionalVarargArgumentDefinition.prototype.provideDelegate_n5byny$ = function (owner, property) {
    var provider = new ArgParser$OptionalVarargArgumentDefinition$provideDelegate$ObjectLiteral(this.argType, property.callableName, this.description, true, true);
    this.$outer.register_1(provider);
    return provider;
  };
  ArgParser$OptionalVarargArgumentDefinition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionalVarargArgumentDefinition',
    interfaces: []
  };
  function ArgParser$Companion() {
    ArgParser$Companion_instance = this;
  }
  ArgParser$Companion.prototype.camelCaseToDashes_omtdrb$ = function (input) {
    var $receiver = StringBuilder_init();
    var tmp$;
    var lastWasLower = false;
    tmp$ = iterator(input);
    while (tmp$.hasNext()) {
      var c = unboxChar(tmp$.next());
      if (this.isSimpleUpperCase_0(c)) {
        if (lastWasLower) {
          lastWasLower = false;
          $receiver.append_s8itvh$(45);
        }$receiver.append_s8itvh$(this.toSimpleLowerCase_0(c));
      } else {
        $receiver.append_s8itvh$(c);
        lastWasLower = true;
      }
    }
    return $receiver.toString();
  };
  ArgParser$Companion.prototype.isSimpleUpperCase_0 = function ($receiver) {
    return (new CharRange(65, 90)).contains_mef7kx$($receiver);
  };
  ArgParser$Companion.prototype.toSimpleLowerCase_0 = function ($receiver) {
    var tmp$;
    if ((new CharRange(65, 90)).contains_mef7kx$($receiver)) {
      var offset = $receiver - 65;
      tmp$ = 'abcdefghijklmnopqrstuvwxyz'.charCodeAt(offset);
    } else {
      tmp$ = $receiver;
    }
    return tmp$;
  };
  ArgParser$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ArgParser$Companion_instance = null;
  function ArgParser$Companion_getInstance() {
    if (ArgParser$Companion_instance === null) {
      new ArgParser$Companion();
    }return ArgParser$Companion_instance;
  }
  function ArgParser_init$ObjectLiteral(this$ArgParser, argType, shortName, name, description, group) {
    this.this$ArgParser = this$ArgParser;
    ArgParser$OptionProvider.call(this, argType, shortName, name, description, group);
  }
  ArgParser_init$ObjectLiteral.prototype.acceptArg_61zpoe$ = function (arg) {
    this.this$ArgParser.helpNeeded = this.argType.read_61zpoe$(arg);
  };
  ArgParser_init$ObjectLiteral.prototype.appendSyntaxSummary_4n11c8$ = function (output) {
  };
  ArgParser_init$ObjectLiteral.prototype.produce = function () {
    return this.this$ArgParser.helpNeeded;
  };
  ArgParser_init$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgParser$OptionProvider]
  };
  ArgParser.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ArgParser',
    interfaces: []
  };
  function ArgType() {
    ArgType$Companion_getInstance();
  }
  Object.defineProperty(ArgType.prototype, 'needsArgument', {
    configurable: true,
    get: function () {
      return true;
    }
  });
  function ArgType$Companion() {
    ArgType$Companion_instance = this;
    this.BOOLEAN = new ArgType$Companion$BOOLEAN$ObjectLiteral();
    this.STRING = new ArgType$Companion$STRING$ObjectLiteral();
    this.INTEGER = new ArgType$Companion$INTEGER$ObjectLiteral();
  }
  function ArgType$Companion$BOOLEAN$ObjectLiteral() {
  }
  ArgType$Companion$BOOLEAN$ObjectLiteral.prototype.read_61zpoe$ = function (str) {
    return equals(str, '') || toBoolean(str);
  };
  Object.defineProperty(ArgType$Companion$BOOLEAN$ObjectLiteral.prototype, 'needsArgument', {
    configurable: true,
    get: function () {
      return false;
    }
  });
  ArgType$Companion$BOOLEAN$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgType]
  };
  function ArgType$Companion$STRING$ObjectLiteral() {
  }
  ArgType$Companion$STRING$ObjectLiteral.prototype.read_61zpoe$ = function (str) {
    return str;
  };
  ArgType$Companion$STRING$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgType]
  };
  function ArgType$Companion$INTEGER$ObjectLiteral() {
  }
  ArgType$Companion$INTEGER$ObjectLiteral.prototype.read_61zpoe$ = function (str) {
    return toInt(str);
  };
  ArgType$Companion$INTEGER$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgType]
  };
  ArgType$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ArgType$Companion_instance = null;
  function ArgType$Companion_getInstance() {
    if (ArgType$Companion_instance === null) {
      new ArgType$Companion();
    }return ArgType$Companion_instance;
  }
  ArgType.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ArgType',
    interfaces: []
  };
  function ArgType$ObjectLiteral(closure$reader) {
    this.closure$reader = closure$reader;
  }
  ArgType$ObjectLiteral.prototype.read_61zpoe$ = function (str) {
    return this.closure$reader(str);
  };
  ArgType$ObjectLiteral.prototype.toString = function () {
    return this.closure$reader.toString();
  };
  ArgType$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ArgType]
  };
  function ArgType_0(reader) {
    return new ArgType$ObjectLiteral(reader);
  }
  function parse($receiver, args) {
    $receiver.parse_upaayv$(toList(args));
  }
  function parseArgv($receiver, args) {
    var tmp$;
    $receiver.parse_upaayv$(toList(args));
    if ($receiver.helpNeeded) {
      print('Options: ' + $receiver.buildSyntax());
      tmp$ = false;
    } else {
      tmp$ = true;
    }
    return tmp$;
  }
  ArgParser.OptionProvider = ArgParser$OptionProvider;
  ArgParser.ArgumentProvider = ArgParser$ArgumentProvider;
  ArgParser.DefaultedSingleOptionDefinition = ArgParser$DefaultedSingleOptionDefinition;
  ArgParser.OptionalSingleOptionDefinition = ArgParser$OptionalSingleOptionDefinition;
  ArgParser.MultipleOptionDefinition = ArgParser$MultipleOptionDefinition;
  ArgParser.GroupCollector = ArgParser$GroupCollector;
  ArgParser.OptionGroupDefinition = ArgParser$OptionGroupDefinition;
  ArgParser.MandatoryArgumentDefinition = ArgParser$MandatoryArgumentDefinition;
  ArgParser.DefaultedArgumentDefinition = ArgParser$DefaultedArgumentDefinition;
  ArgParser.OptionalArgumentDefinition = ArgParser$OptionalArgumentDefinition;
  ArgParser.MandatoryVarargArgumentDefinition = ArgParser$MandatoryVarargArgumentDefinition;
  ArgParser.OptionalVarargArgumentDefinition = ArgParser$OptionalVarargArgumentDefinition;
  Object.defineProperty(ArgParser, 'Companion', {
    get: ArgParser$Companion_getInstance
  });
  var package$org = _.org || (_.org = {});
  var package$araqnid = package$org.araqnid || (package$org.araqnid = {});
  var package$kotlin = package$araqnid.kotlin || (package$araqnid.kotlin = {});
  var package$argv = package$kotlin.argv || (package$kotlin.argv = {});
  package$argv.ArgParser = ArgParser;
  Object.defineProperty(ArgType, 'Companion', {
    get: ArgType$Companion_getInstance
  });
  package$argv.ArgType = ArgType;
  package$argv.ArgType_cq6yhu$ = ArgType_0;
  package$argv.parse_tn4yg6$ = parse;
  package$argv.parseArgv_tn4yg6$ = parseArgv;
  Object.defineProperty(ArgType$Companion$STRING$ObjectLiteral.prototype, 'needsArgument', Object.getOwnPropertyDescriptor(ArgType.prototype, 'needsArgument'));
  Object.defineProperty(ArgType$Companion$INTEGER$ObjectLiteral.prototype, 'needsArgument', Object.getOwnPropertyDescriptor(ArgType.prototype, 'needsArgument'));
  Object.defineProperty(ArgType$ObjectLiteral.prototype, 'needsArgument', Object.getOwnPropertyDescriptor(ArgType.prototype, 'needsArgument'));
  Kotlin.defineModule('arg-parser-js-legacy', _);
  return _;
}(module.exports, require('kotlin')));

//# sourceMappingURL=arg-parser-js-legacy.js.map
