/*
 * Decompiled with CFR 0.152.
 */
package org.araqnid.kotlin.assertthat;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.araqnid.kotlin.assertthat.AssertionResult;
import org.araqnid.kotlin.assertthat.DescribeKt;
import org.araqnid.kotlin.assertthat.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\u001a!\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0001\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0007\u001a!\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0007\u001a&\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0001\"\b\b\u0000\u0010\u0005*\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0001\u001a\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0001\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0007\"\u0019\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\f"}, d2={"isAbsent", "Lorg/araqnid/kotlin/assertthat/Matcher;", "", "()Lorg/araqnid/kotlin/assertthat/Matcher;", "equalTo", "T", "value", "(Ljava/lang/Object;)Lorg/araqnid/kotlin/assertthat/Matcher;", "isEqualTo", "present", "valueMatcher", "sameInstance", "assert-that"})
public final class BasicMatchersKt {
    @NotNull
    private static final Matcher<Object> isAbsent = new Matcher<Object>(){
        @NotNull
        private final String description;

        @NotNull
        public AssertionResult match(@Nullable Object actual) {
            if (actual == null) {
                return AssertionResult.Match.INSTANCE;
            }
            return new AssertionResult.Mismatch("was " + DescribeKt.describe(actual));
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }
        {
            this.description = "null";
        }

        @NotNull
        public String getNegatedDescription() {
            return Matcher.DefaultImpls.getNegatedDescription(this);
        }

        @NotNull
        public Matcher<Object> not() {
            return Matcher.DefaultImpls.not(this);
        }

        @NotNull
        public Function1<Object, Boolean> asPredicate() {
            return Matcher.DefaultImpls.asPredicate(this);
        }
    };

    @NotNull
    public static final Matcher<Object> isAbsent() {
        return isAbsent;
    }

    @NotNull
    public static final <T> Matcher<T> present(@NotNull Matcher<? super T> valueMatcher) {
        Intrinsics.checkNotNullParameter(valueMatcher, (String)"valueMatcher");
        return new Matcher<T>(valueMatcher){
            final /* synthetic */ Matcher $valueMatcher;

            @NotNull
            public AssertionResult match(@Nullable T actual) {
                if (actual == null) {
                    return new AssertionResult.Mismatch("was null");
                }
                return this.$valueMatcher.match(actual);
            }

            @NotNull
            public String getDescription() {
                return this.$valueMatcher.getDescription();
            }
            {
                this.$valueMatcher = $captured_local_variable$0;
            }

            @NotNull
            public String getNegatedDescription() {
                return Matcher.DefaultImpls.getNegatedDescription(this);
            }

            @NotNull
            public Matcher<T> not() {
                return Matcher.DefaultImpls.not(this);
            }

            @NotNull
            public Function1<T, Boolean> asPredicate() {
                return Matcher.DefaultImpls.asPredicate(this);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<T> equalTo(T value) {
        return new Matcher<T>(value){
            final /* synthetic */ Object $value;

            @NotNull
            public AssertionResult match(@Nullable T actual) {
                if (Intrinsics.areEqual(actual, (Object)this.$value)) {
                    return AssertionResult.Match.INSTANCE;
                }
                return new AssertionResult.Mismatch("was " + DescribeKt.describe(actual));
            }

            @NotNull
            public String getDescription() {
                return "is equal to " + DescribeKt.describe(this.$value);
            }

            @NotNull
            public String getNegatedDescription() {
                return "is not equal to " + DescribeKt.describe(this.$value);
            }
            {
                this.$value = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<T> not() {
                return Matcher.DefaultImpls.not(this);
            }

            @NotNull
            public Function1<T, Boolean> asPredicate() {
                return Matcher.DefaultImpls.asPredicate(this);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Object> isEqualTo(T value) {
        return new Matcher<Object>(value){
            final /* synthetic */ Object $value;

            @NotNull
            public AssertionResult match(@Nullable Object actual) {
                if (Intrinsics.areEqual((Object)actual, (Object)this.$value)) {
                    return AssertionResult.Match.INSTANCE;
                }
                return new AssertionResult.Mismatch("was " + DescribeKt.describe(actual));
            }

            @NotNull
            public String getDescription() {
                return "is equal to " + DescribeKt.describe(this.$value);
            }

            @NotNull
            public String getNegatedDescription() {
                return "is not equal to " + DescribeKt.describe(this.$value);
            }
            {
                this.$value = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<Object> not() {
                return Matcher.DefaultImpls.not(this);
            }

            @NotNull
            public Function1<Object, Boolean> asPredicate() {
                return Matcher.DefaultImpls.asPredicate(this);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<T> sameInstance(T value) {
        return new Matcher<T>(value){
            final /* synthetic */ Object $value;

            @NotNull
            public AssertionResult match(T actual) {
                if (actual == this.$value) {
                    return AssertionResult.Match.INSTANCE;
                }
                return new AssertionResult.Mismatch("was " + DescribeKt.describe(actual));
            }

            @NotNull
            public String getDescription() {
                return "is same instance as " + DescribeKt.describe(this.$value);
            }

            @NotNull
            public String getNegatedDescription() {
                return "is not same instance as " + DescribeKt.describe(this.$value);
            }
            {
                this.$value = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<T> not() {
                return Matcher.DefaultImpls.not(this);
            }

            @NotNull
            public Function1<T, Boolean> asPredicate() {
                return Matcher.DefaultImpls.asPredicate(this);
            }
        };
    }
}

