/*
 * Decompiled with CFR 0.152.
 */
package org.araqnid.kotlin.assertthat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.araqnid.kotlin.assertthat.AssertionResult;
import org.araqnid.kotlin.assertthat.BasicMatchersKt;
import org.araqnid.kotlin.assertthat.CollectionMatchersKt;
import org.araqnid.kotlin.assertthat.CollectionMatchersKt$hasSize$1;
import org.araqnid.kotlin.assertthat.DescribeKt;
import org.araqnid.kotlin.assertthat.Matcher;
import org.araqnid.kotlin.assertthat.PredicateMatcherKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u001a=\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00020\u0001\"\u0004\b\u0000\u0010\u00072\u001e\u0010\b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00010\t\"\b\u0012\u0004\u0012\u0002H\u00070\u0001\u00a2\u0006\u0002\u0010\n\u001a=\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00020\u0001\"\u0004\b\u0000\u0010\u00072\u001e\u0010\b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00010\t\"\b\u0012\u0004\u0012\u0002H\u00070\u0001\u00a2\u0006\u0002\u0010\n\u001a&\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00020\u0001\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0001\u001a&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00020\u0001\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0001\u001a\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"emptyCollection", "Lorg/araqnid/kotlin/assertthat/Matcher;", "", "", "getEmptyCollection", "()Lorg/araqnid/kotlin/assertthat/Matcher;", "containsInAnyOrder", "T", "expected", "", "([Lorg/araqnid/kotlin/assertthat/Matcher;)Lorg/araqnid/kotlin/assertthat/Matcher;", "containsInOrder", "containsOnly", "containsTheItem", "hasSize", "expectedSize", "", "assert-that"})
public final class CollectionMatchersKt {
    @NotNull
    private static final Matcher<Collection<? extends Object>> emptyCollection = new Matcher<Collection<? extends Object>>(){
        @NotNull
        private final String description;
        @NotNull
        private final String negatedDescription;

        @NotNull
        public AssertionResult match(@NotNull Collection<? extends Object> actual) {
            Intrinsics.checkNotNullParameter(actual, (String)"actual");
            return actual.isEmpty() ? (AssertionResult)AssertionResult.Match.INSTANCE : (AssertionResult)new AssertionResult.Mismatch("had these items: " + DescribeKt.describe(actual));
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public String getNegatedDescription() {
            return this.negatedDescription;
        }
        {
            this.description = "is empty";
            this.negatedDescription = "is not empty";
        }

        @NotNull
        public Matcher<Collection<? extends Object>> not() {
            return Matcher.DefaultImpls.not(this);
        }

        @NotNull
        public Function1<Collection<? extends Object>, Boolean> asPredicate() {
            return Matcher.DefaultImpls.asPredicate(this);
        }
    };

    @NotNull
    public static final Matcher<Collection<? extends Object>> getEmptyCollection() {
        return emptyCollection;
    }

    @NotNull
    public static final Matcher<Collection<?>> hasSize(int expectedSize) {
        return PredicateMatcherKt.has(CollectionMatchersKt$hasSize$1.INSTANCE, BasicMatchersKt.equalTo(expectedSize));
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> containsTheItem(@NotNull Matcher<? super T> expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new Matcher<Collection<? extends T>>(expected){
            @NotNull
            private final String description;
            @NotNull
            private final String negatedDescription;
            final /* synthetic */ Matcher $expected;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public AssertionResult match(@NotNull Collection<? extends T> actual) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(actual, (String)"actual");
                if (actual.isEmpty()) {
                    return new AssertionResult.Mismatch("was empty");
                }
                Iterable $this$map$iv = actual;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    AssertionResult assertionResult = this.$expected.match(it);
                    collection.add(assertionResult);
                }
                List results = (List)destination$iv$iv;
                if (results.contains(AssertionResult.Match.INSTANCE)) {
                    return AssertionResult.Match.INSTANCE;
                }
                boolean bl = false;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder $this$buildString = stringBuilder;
                boolean bl5 = false;
                $this$buildString.append("did not contain match");
                Iterable $this$forEachIndexed$iv = results;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void result;
                    int n = index$iv++;
                    boolean bl6 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    AssertionResult assertionResult = (AssertionResult)item$iv;
                    int index = n;
                    boolean bl7 = false;
                    $this$buildString.append("\n#" + index + ": " + DescribeKt.describe(result));
                }
                Unit unit = Unit.INSTANCE;
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String string2 = string;
                return new AssertionResult.Mismatch(string2);
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public String getNegatedDescription() {
                return this.negatedDescription;
            }
            {
                this.$expected = $captured_local_variable$0;
                this.description = "contains " + DescribeKt.describe($captured_local_variable$0);
                this.negatedDescription = "does not contain " + DescribeKt.describe($captured_local_variable$0);
            }

            @NotNull
            public Matcher<Collection<? extends T>> not() {
                return Matcher.DefaultImpls.not(this);
            }

            @NotNull
            public Function1<Collection<? extends T>, Boolean> asPredicate() {
                return Matcher.DefaultImpls.asPredicate(this);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> containsOnly(@NotNull Matcher<? super T> expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new Matcher<Collection<? extends T>>(expected){
            @NotNull
            private final String description;
            @NotNull
            private final String negatedDescription;
            final /* synthetic */ Matcher $expected;

            @NotNull
            public AssertionResult match(@NotNull Collection<? extends T> actual) {
                AssertionResult assertionResult;
                Intrinsics.checkNotNullParameter(actual, (String)"actual");
                if (actual.isEmpty()) {
                    assertionResult = new AssertionResult.Mismatch("was empty");
                } else if (actual.size() > 1) {
                    assertionResult = new AssertionResult.Mismatch("had multiple items: " + DescribeKt.describe(actual));
                } else {
                    AssertionResult match2 = this.$expected.match(CollectionsKt.single((Iterable)actual));
                    if (Intrinsics.areEqual((Object)match2, (Object)AssertionResult.Match.INSTANCE)) {
                        assertionResult = AssertionResult.Match.INSTANCE;
                    } else if (match2 instanceof AssertionResult.Mismatch) {
                        assertionResult = ((AssertionResult.Mismatch)match2).mapMessage((Function1<? super String, String>)((Function1)containsOnly.match.1.INSTANCE));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return assertionResult;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public String getNegatedDescription() {
                return this.negatedDescription;
            }
            {
                this.$expected = $captured_local_variable$0;
                this.description = "contains a single item that " + DescribeKt.describe($captured_local_variable$0);
                this.negatedDescription = "does not a single item that " + DescribeKt.describe($captured_local_variable$0);
            }

            @NotNull
            public Matcher<Collection<? extends T>> not() {
                return Matcher.DefaultImpls.not(this);
            }

            @NotNull
            public Function1<Collection<? extends T>, Boolean> asPredicate() {
                return Matcher.DefaultImpls.asPredicate(this);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> containsInOrder(Matcher<? super T> ... expected) {
        Matcher<Collection<Object>> matcher;
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        switch (expected.length) {
            case 0: {
                matcher = emptyCollection;
                break;
            }
            case 1: {
                matcher = CollectionMatchersKt.containsOnly((Matcher)ArraysKt.single((Object[])expected));
                break;
            }
            default: {
                matcher = new Matcher<Collection<? extends T>>(expected){
                    @NotNull
                    private final String description;
                    @NotNull
                    private final String negatedDescription;
                    final /* synthetic */ Matcher[] $expected;

                    @NotNull
                    public AssertionResult match(@NotNull Collection<? extends T> actual) {
                        Intrinsics.checkNotNullParameter(actual, (String)"actual");
                        if (actual.isEmpty()) {
                            return new AssertionResult.Mismatch("was empty");
                        }
                        Iterator expectedIter = ArrayIteratorKt.iterator((Object[])this.$expected);
                        Iterator<T> actualIter = actual.iterator();
                        int index = 0;
                        while (expectedIter.hasNext() && actualIter.hasNext()) {
                            T actualItem;
                            Matcher itemMatcher = (Matcher)expectedIter.next();
                            AssertionResult itemMatch = itemMatcher.match(actualItem = actualIter.next());
                            if (itemMatch instanceof AssertionResult.Mismatch) {
                                return new AssertionResult.Mismatch("item at #" + index + ' ' + ((AssertionResult.Mismatch)itemMatch).getDescription());
                            }
                            ++index;
                        }
                        if (expectedIter.hasNext()) {
                            return new AssertionResult.Mismatch("did not have these items: " + DescribeKt.describe(SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)expectedIter))));
                        }
                        if (actualIter.hasNext()) {
                            return new AssertionResult.Mismatch("had these extra items: " + DescribeKt.describe(SequencesKt.toList((Sequence)SequencesKt.asSequence(actualIter))));
                        }
                        return AssertionResult.Match.INSTANCE;
                    }

                    @NotNull
                    public String getDescription() {
                        return this.description;
                    }

                    @NotNull
                    public String getNegatedDescription() {
                        return this.negatedDescription;
                    }
                    {
                        this.$expected = $captured_local_variable$0;
                        this.description = "contains " + DescribeKt.describe(ArraysKt.toList((Object[])$captured_local_variable$0));
                        this.negatedDescription = "does not contain " + DescribeKt.describe(ArraysKt.toList((Object[])$captured_local_variable$0));
                    }

                    @NotNull
                    public Matcher<Collection<? extends T>> not() {
                        return Matcher.DefaultImpls.not(this);
                    }

                    @NotNull
                    public Function1<Collection<? extends T>, Boolean> asPredicate() {
                        return Matcher.DefaultImpls.asPredicate(this);
                    }
                };
            }
        }
        return matcher;
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> containsInAnyOrder(Matcher<? super T> ... expected) {
        Matcher<Collection<Object>> matcher;
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        switch (expected.length) {
            case 0: {
                matcher = emptyCollection;
                break;
            }
            case 1: {
                matcher = CollectionMatchersKt.containsOnly((Matcher)ArraysKt.single((Object[])expected));
                break;
            }
            default: {
                matcher = new Matcher<Collection<? extends T>>(expected){
                    @NotNull
                    private final String description;
                    @NotNull
                    private final String negatedDescription;
                    final /* synthetic */ Matcher[] $expected;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public AssertionResult match(@NotNull Collection<? extends T> actual) {
                        Intrinsics.checkNotNullParameter(actual, (String)"actual");
                        if (actual.isEmpty()) {
                            return new AssertionResult.Mismatch("was empty");
                        }
                        List remaining = ArraysKt.toMutableList((Object[])this.$expected);
                        Iterator<T> actualIter = actual.iterator();
                        int counter = 0;
                        block0: while (actualIter.hasNext()) {
                            T actualItem = actualIter.next();
                            int index = counter++;
                            Iterator<E> remainingIter = remaining.iterator();
                            boolean bl = false;
                            List mismatches = new ArrayList<E>();
                            while (remainingIter.hasNext()) {
                                Matcher matcher = (Matcher)remainingIter.next();
                                AssertionResult match2 = matcher.match(actualItem);
                                if (Intrinsics.areEqual((Object)match2, (Object)AssertionResult.Match.INSTANCE)) {
                                    remainingIter.remove();
                                    continue block0;
                                }
                                if (!(match2 instanceof AssertionResult.Mismatch)) continue;
                                Collection collection = mismatches;
                                Pair pair = TuplesKt.to((Object)matcher, (Object)match2);
                                boolean bl2 = false;
                                collection.add(pair);
                            }
                            bl = false;
                            boolean bl3 = false;
                            StringBuilder stringBuilder = new StringBuilder();
                            boolean bl4 = false;
                            boolean bl5 = false;
                            StringBuilder $this$buildString = stringBuilder;
                            boolean bl6 = false;
                            $this$buildString.append("item #" + index + " did not match:");
                            for (Pair pair : mismatches) {
                                void matcher;
                                Matcher matcher2 = (Matcher)pair.component1();
                                AssertionResult.Mismatch mismatch = (AssertionResult.Mismatch)pair.component2();
                                $this$buildString.append("\n " + DescribeKt.describe(matcher) + ": " + mismatch.getDescription());
                            }
                            Unit unit = Unit.INSTANCE;
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                            String string2 = string;
                            return new AssertionResult.Mismatch(string2);
                        }
                        Collection collection = remaining;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            return new AssertionResult.Mismatch("did not have these items: " + DescribeKt.describe(CollectionsKt.toList((Iterable)remaining)));
                        }
                        if (actualIter.hasNext()) {
                            return new AssertionResult.Mismatch("had these extra items: " + DescribeKt.describe(SequencesKt.toList((Sequence)SequencesKt.asSequence(actualIter))));
                        }
                        return AssertionResult.Match.INSTANCE;
                    }

                    @NotNull
                    public String getDescription() {
                        return this.description;
                    }

                    @NotNull
                    public String getNegatedDescription() {
                        return this.negatedDescription;
                    }
                    {
                        this.$expected = $captured_local_variable$0;
                        this.description = "contains (in any order) " + DescribeKt.describe(ArraysKt.toList((Object[])$captured_local_variable$0));
                        this.negatedDescription = "does not contain (in any order) " + DescribeKt.describe(ArraysKt.toList((Object[])$captured_local_variable$0));
                    }

                    @NotNull
                    public Matcher<Collection<? extends T>> not() {
                        return Matcher.DefaultImpls.not(this);
                    }

                    @NotNull
                    public Function1<Collection<? extends T>, Boolean> asPredicate() {
                        return Matcher.DefaultImpls.asPredicate(this);
                    }
                };
            }
        }
        return matcher;
    }
}

