/*
 * Decompiled with CFR 0.152.
 */
package org.araqnid.kotlin.assertthat;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.araqnid.kotlin.assertthat.AssertionResult;
import org.araqnid.kotlin.assertthat.Matcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/araqnid/kotlin/assertthat/FeatureMatcher;", "T", "R", "Lorg/araqnid/kotlin/assertthat/Matcher;", "name", "", "feature", "Lkotlin/Function1;", "featureMatcher", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lorg/araqnid/kotlin/assertthat/Matcher;)V", "description", "getDescription", "()Ljava/lang/String;", "negatedDescription", "getNegatedDescription", "match", "Lorg/araqnid/kotlin/assertthat/AssertionResult;", "actual", "(Ljava/lang/Object;)Lorg/araqnid/kotlin/assertthat/AssertionResult;", "assert-that"})
final class FeatureMatcher<T, R>
implements Matcher<T> {
    @NotNull
    private final String description;
    @NotNull
    private final String negatedDescription;
    private final String name;
    private final Function1<T, R> feature;
    private final Matcher<R> featureMatcher;

    @Override
    @NotNull
    public AssertionResult match(T actual) {
        AssertionResult result = this.featureMatcher.match(this.feature.invoke(actual));
        if (result instanceof AssertionResult.Mismatch) {
            return new AssertionResult.Mismatch("had " + this.name + " that " + ((AssertionResult.Mismatch)result).getDescription());
        }
        return AssertionResult.Match.INSTANCE;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getNegatedDescription() {
        return this.negatedDescription;
    }

    public FeatureMatcher(@NotNull String name, @NotNull Function1<? super T, ? extends R> feature, @NotNull Matcher<? super R> featureMatcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(feature, (String)"feature");
        Intrinsics.checkNotNullParameter(featureMatcher, (String)"featureMatcher");
        this.name = name;
        this.feature = feature;
        this.featureMatcher = featureMatcher;
        this.description = "has " + this.name + " that " + this.featureMatcher.getDescription();
        this.negatedDescription = "does not have " + this.name + " that " + this.featureMatcher.getDescription();
    }

    @Override
    @NotNull
    public Matcher<T> not() {
        return Matcher.DefaultImpls.not(this);
    }

    @Override
    @NotNull
    public Function1<T, Boolean> asPredicate() {
        return Matcher.DefaultImpls.asPredicate(this);
    }
}

