/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.domain.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.domain.insight.InsightKeywordsKt;
import org.archguard.domain.insight.InsightsParserKt;
import org.archguard.domain.insight.Query;
import org.archguard.domain.insight.Token;
import org.archguard.domain.insight.TokenType;
import org.archguard.domain.insight.support.InsightIllegalException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/archguard/domain/insight/InsightsParser;", "", "()V", "queryCache", "Ljava/util/HashMap;", "", "Lorg/archguard/domain/insight/Query;", "Lkotlin/collections/HashMap;", "parse", "input", "tokenize", "", "Lorg/archguard/domain/insight/Token;", "text", "domain"})
public final class InsightsParser {
    @NotNull
    public static final InsightsParser INSTANCE = new InsightsParser();
    @NotNull
    private static final HashMap<String, Query> queryCache = new HashMap();

    private InsightsParser() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<Token> tokenize(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        length = text.length();
        current = 0;
        tokens = new ArrayList<E>();
        maybeVersion = true;
        while (current < length) {
            block18: {
                c = text.charAt(current);
                if (!InsightsParserKt.getVERSION_REG_LOOSE().matches((CharSequence)String.valueOf(c)) || !maybeVersion) break block18;
                var8_12 = c;
                var9_16 = "";
                buff = var8_12 + var9_16;
                pc = current;
                while (current < length - 1 && InsightsParserKt.getVERSION_REG_LOOSE().matches((CharSequence)buff)) {
                    buff = buff + text.charAt(++current);
                }
                finalVersion = null;
                if (current + 1 != length) ** GOTO lbl-1000
                var10_17 = buff;
                if (InsightsParserKt.getVERSION_REG().matches(var10_17)) {
                    finalVersion = buff;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = buff.substring(0, buff.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    var10_17 = v0;
                    if (InsightsParserKt.getVERSION_REG().matches(var10_17)) {
                        v1 = buff.substring(0, buff.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        finalVersion = v1;
                    } else {
                        current = pc;
                        maybeVersion = false;
                        continue;
                    }
                }
                tokens.add(new Token(TokenType.VersionKind, finalVersion, pc, current++));
                continue;
            }
            if (InsightsParserKt.getCHAR_REG().matches((CharSequence)String.valueOf(c))) {
                start = current;
                value = String.valueOf(c);
                while (current + 1 < length && InsightsParserKt.getCHAR_REG().matches((CharSequence)String.valueOf(text.charAt(current + 1)))) {
                    value = value + text.charAt(current + 1);
                    ++current;
                }
                token = InsightKeywordsKt.getCOMBINATOR_KEYWORDS().contains(value) != false ? new Token(TokenType.Combinator, value, start, current) : new Token(TokenType.Identifier, value, start, ++current);
                tokens.add(token);
                maybeVersion = true;
                continue;
            }
            if (InsightKeywordsKt.getWRAPPER_SYMBOLS().contains(Character.valueOf(c))) {
                value = String.valueOf(c);
                start = current;
                while (current + 1 < length && text.charAt(current + 1) != c) {
                    value = value + text.charAt(current + 1);
                    ++current;
                }
                if (current + 1 < length && text.charAt(current + 1) == c) {
                    ++current;
                    value = value + c;
                    tokens.add(new Token(TokenType.Companion.fromChar(c), value, start, ++current));
                } else {
                    current = start;
                    tokens.add(new Token(TokenType.Unknown, String.valueOf(c), start, ++current));
                }
                maybeVersion = true;
                continue;
            }
            if (InsightsParserKt.getCOMPARATOR_REG().matches((CharSequence)String.valueOf(c))) {
                start = current;
                value = String.valueOf(c);
                while (current < length && InsightsParserKt.getCOMPARATOR_REG().matches((CharSequence)String.valueOf(text.charAt(current + 1)))) {
                    value = value + text.charAt(current + 1);
                    ++current;
                }
                tokens.add(InsightKeywordsKt.getCOMPARATOR_KEYWORDS().contains(value) != false ? new Token(TokenType.ComparisonKind, value, start, current) : new Token(TokenType.Unknown, value, start, ++current));
                maybeVersion = true;
                continue;
            }
            if (InsightsParserKt.getLOGIC_REG().matches((CharSequence)String.valueOf(c))) {
                start = current;
                if (current + 1 < length && text.charAt(current + 1) == c) {
                    tokens.add(new Token(TokenType.Combinator, "" + c + c, start, current += 2));
                } else {
                    tokens.add(new Token(TokenType.Unknown, String.valueOf(c), start, ++current));
                }
                maybeVersion = true;
                continue;
            }
            if (InsightsParserKt.getNEW_LINE().matches((CharSequence)String.valueOf(c))) {
                ++current;
                continue;
            }
            tokens.add(new Token(TokenType.Unknown, String.valueOf(c), current++, current));
            maybeVersion = true;
        }
        return tokens;
    }

    @NotNull
    public final Query parse(@NotNull String input) {
        boolean bl;
        List<Token> tokens;
        block5: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (queryCache.containsKey(input)) {
                Query query = queryCache.get(input);
                Intrinsics.checkNotNull((Object)query);
                return query;
            }
            tokens = this.tokenize(input);
            Iterable $this$any$iv = tokens;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Token it = (Token)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == TokenType.Unknown)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new InsightIllegalException("Input is not a valid query");
        }
        Query query = Query.Companion.fromTokens(tokens);
        ((Map)queryCache).put(input, query);
        return query;
    }
}

