/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.domain.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.domain.comparison.Comparison;
import org.archguard.domain.insight.CombinatorType;
import org.archguard.domain.insight.Either;
import org.archguard.domain.insight.QueryCombinator;
import org.archguard.domain.insight.QueryExpression;
import org.archguard.domain.insight.QueryMode;
import org.archguard.domain.insight.RegexQuery;
import org.archguard.domain.insight.Token;
import org.archguard.domain.insight.TokenType;
import org.archguard.domain.insight.VersionQuery;
import org.archguard.domain.insight.support.InsightIllegalException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B;\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fR#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/archguard/domain/insight/Query;", "", "query", "", "Lorg/archguard/domain/insight/Either;", "Lorg/archguard/domain/insight/QueryExpression;", "Lorg/archguard/domain/insight/QueryCombinator;", "postqueries", "Lorg/archguard/domain/insight/RegexQuery;", "Lorg/archguard/domain/insight/VersionQuery;", "(Ljava/util/List;Ljava/util/List;)V", "getPostqueries", "()Ljava/util/List;", "getQuery", "toSQL", "", "prefix", "Companion", "domain"})
public final class Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Either<QueryExpression, QueryCombinator>> query;
    @NotNull
    private final List<Either<RegexQuery, VersionQuery>> postqueries;

    private Query(List<Either<QueryExpression, QueryCombinator>> query, List<Either<RegexQuery, VersionQuery>> postqueries) {
        this.query = query;
        this.postqueries = postqueries;
    }

    @NotNull
    public final List<Either<QueryExpression, QueryCombinator>> getQuery() {
        return this.query;
    }

    @NotNull
    public final List<Either<RegexQuery, VersionQuery>> getPostqueries() {
        return this.postqueries;
    }

    @NotNull
    public final String toSQL(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.query.isEmpty()) {
            return prefix + " 1=1";
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = this.query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Either it = (Either)element$iv;
            boolean bl = false;
            if (it.isLeft()) {
                Object a = it.getLeftOrNull();
                Intrinsics.checkNotNull(a);
                QueryExpression expr = (QueryExpression)a;
                switch (WhenMappings.$EnumSwitchMapping$0[expr.getQueryMode().ordinal()]) {
                    case 1: {
                        sb.append(expr.getLeft() + ' ' + (Object)((Object)expr.getComparison()) + " '" + StringsKt.replace$default((String)expr.getRight(), (String)"'", (String)"''", (boolean)false, (int)4, null) + '\'');
                        break;
                    }
                    case 2: {
                        if (expr.getComparison() == Comparison.Equal) {
                            sb.append(expr.getLeft() + " LIKE '" + StringsKt.replace$default((String)expr.getRight(), (String)"'", (String)"''", (boolean)false, (int)4, null) + '\'');
                            break;
                        }
                        sb.append(expr.getLeft() + " NOT LIKE '" + StringsKt.replace$default((String)expr.getRight(), (String)"'", (String)"''", (boolean)false, (int)4, null) + '\'');
                        break;
                    }
                    case 3: {
                        throw new InsightIllegalException("SQL query is not support regex mode");
                    }
                    case 4: {
                        throw new InsightIllegalException("SQL query is not support semver mode");
                    }
                }
                continue;
            }
            Object b = it.getRightOrNull();
            Intrinsics.checkNotNull(b);
            QueryCombinator comb = (QueryCombinator)b;
            switch (WhenMappings.$EnumSwitchMapping$1[comb.getType().ordinal()]) {
                case 1: {
                    sb.append(" AND ");
                    break;
                }
                case 2: {
                    sb.append(" OR ");
                }
            }
        }
        return prefix + ' ' + sb;
    }

    public static /* synthetic */ String toSQL$default(Query query, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "WHERE";
        }
        return query.toSQL(string);
    }

    public /* synthetic */ Query(List query, List postqueries, DefaultConstructorMarker $constructor_marker) {
        this(query, postqueries);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J>\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\t0\bH\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\tH\u0002J(\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\t0\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002JD\u0010\u001e\u001a\u00020\u000f2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\t0\u00112\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010 \u001a\u00020!H\u0002J<\u0010\"\u001a\u00020\u000f2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\t0\u00112\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bH\u0002\u00a8\u0006$"}, d2={"Lorg/archguard/domain/insight/Query$Companion;", "", "()V", "addToPostQueries", "", "postquery", "Lorg/archguard/domain/insight/QueryExpression;", "postqueries", "", "Lorg/archguard/domain/insight/Either;", "Lorg/archguard/domain/insight/RegexQuery;", "Lorg/archguard/domain/insight/VersionQuery;", "combinatorType", "Lorg/archguard/domain/insight/CombinatorType;", "fromTokens", "Lorg/archguard/domain/insight/Query;", "tokens", "", "Lorg/archguard/domain/insight/Token;", "handleWrappingValue", "left", "", "comparison", "Lorg/archguard/domain/comparison/Comparison;", "it", "result", "Lorg/archguard/domain/insight/QueryCombinator;", "isValidPostqueryMode", "", "parseQueries", "queryWithThen", "allQueries", "thenIndex", "", "queryWithoutThen", "postQueries", "domain"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Query fromTokens(@NotNull List<Token> tokens) {
            int n;
            List postqueries;
            List<Either<QueryExpression, QueryCombinator>> allQueries;
            block2: {
                Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
                allQueries = this.parseQueries(tokens);
                postqueries = new ArrayList();
                List<Either<QueryExpression, QueryCombinator>> $this$indexOfFirst$iv = allQueries;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Either<QueryExpression, QueryCombinator>> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Either<QueryExpression, QueryCombinator> item$iv;
                    Either<QueryExpression, QueryCombinator> it = item$iv = iterator.next();
                    boolean bl = false;
                    QueryCombinator queryCombinator = it.getRightOrNull();
                    if ((queryCombinator != null ? queryCombinator.getType() : null) == CombinatorType.Then) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int thenIndex = n;
            boolean hasThen = thenIndex >= 0;
            return !hasThen ? this.queryWithoutThen(allQueries, postqueries) : this.queryWithThen(allQueries, postqueries, thenIndex);
        }

        private final List<Either<QueryExpression, QueryCombinator>> parseQueries(List<Token> tokens) {
            String left = null;
            Comparison comparison = null;
            boolean valid = false;
            List result = new ArrayList();
            Iterable $this$forEach$iv = tokens;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Token it = (Token)element$iv;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                    case 1: {
                        if (!valid) {
                            throw new InsightIllegalException("Combinator should followed by a full expression");
                        }
                        left = null;
                        comparison = null;
                        valid = false;
                        result.add(Either.Companion.Right(new QueryCombinator(it.getValue(), CombinatorType.Companion.fromString(it.getValue()))));
                        break;
                    }
                    case 2: {
                        left = it.getValue();
                        break;
                    }
                    case 3: {
                        comparison = Comparison.Companion.fromString(it.getValue());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        valid = true;
                        Companion.handleWrappingValue(left, comparison, it, result);
                        break;
                    }
                    case 7: {
                        valid = true;
                        if (left == null || comparison == null) {
                            throw new InsightIllegalException("Version query is not valid");
                        }
                        result.add(Either.Companion.Left(new QueryExpression(left, it.getValue(), QueryMode.SemverMode, comparison)));
                        break;
                    }
                    case 8: {
                        throw new InsightIllegalException("Input should not contains unknown type token");
                    }
                }
            }
            if (!((Either)CollectionsKt.last((List)result)).isLeft()) {
                throw new InsightIllegalException("Combinator should not presents at the end of query");
            }
            return result;
        }

        private final void handleWrappingValue(String left, Comparison comparison, Token it, List<Either<QueryExpression, QueryCombinator>> result) {
            Pair pair;
            if (left == null) {
                throw new InsightIllegalException("Identifier is not presents");
            }
            if (comparison == null) {
                throw new InsightIllegalException("Comparator is not presents");
            }
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 4: {
                    String pureString = StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)it.getValue(), (CharSequence)"\""), (CharSequence)"'"), (CharSequence)"`");
                    pair = new Pair((Object)pureString, (Object)QueryMode.StrictMode);
                    break;
                }
                case 6: {
                    pair = new Pair((Object)StringsKt.removeSurrounding((String)it.getValue(), (CharSequence)"@"), (Object)QueryMode.LikeMode);
                    break;
                }
                case 5: {
                    pair = new Pair((Object)StringsKt.removeSurrounding((String)it.getValue(), (CharSequence)"/"), (Object)QueryMode.RegexMode);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected else branch");
                }
            }
            Pair pair2 = pair;
            QueryExpression queryExpression = new QueryExpression(left, (String)pair2.getFirst(), (QueryMode)((Object)pair2.getSecond()), comparison);
            result.add(Either.Companion.Left(queryExpression));
        }

        private final Query queryWithThen(List<Either<QueryExpression, QueryCombinator>> allQueries, List<Either<RegexQuery, VersionQuery>> postqueries, int thenIndex) {
            boolean queryHasRegex;
            List query;
            block7: {
                boolean bl;
                List resultReversed = CollectionsKt.reversed((Iterable)allQueries);
                boolean needBreak = false;
                Iterator iterator = resultReversed.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    CombinatorType combinatorType;
                    int index = n++;
                    Either current = (Either)iterator.next();
                    if (!current.isLeft()) continue;
                    Object a = current.getLeftOrNull();
                    Intrinsics.checkNotNull(a);
                    QueryExpression postquery = (QueryExpression)a;
                    Either next = index < resultReversed.size() - 1 ? (Either)resultReversed.get(index + 1) : (Either)null;
                    Object object = next;
                    if ((object != null && (object = (QueryCombinator)((Either)object).getRightOrNull()) != null ? ((QueryCombinator)object).getType() : null) == CombinatorType.Then) {
                        needBreak = true;
                        combinatorType = null;
                    } else {
                        Object object2 = next;
                        combinatorType = object2 != null && (object2 = (QueryCombinator)((Either)object2).getRightOrNull()) != null ? ((QueryCombinator)object2).getType() : null;
                    }
                    this.addToPostQueries(postquery, postqueries, combinatorType);
                    if (!needBreak) continue;
                }
                query = CollectionsKt.slice(allQueries, (IntRange)RangesKt.until((int)0, (int)thenIndex));
                Iterable $this$any$iv = query;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Either it = (Either)element$iv;
                        boolean bl2 = false;
                        QueryExpression queryExpression = (QueryExpression)it.getLeftOrNull();
                        if (!((queryExpression != null ? queryExpression.getQueryMode() : null) == QueryMode.RegexMode)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = queryHasRegex = false;
                }
            }
            if (queryHasRegex) {
                throw new InsightIllegalException("SQL Queries should not contains RegexMode conditions");
            }
            return new Query(query, postqueries, null);
        }

        private final void addToPostQueries(QueryExpression postquery, List<Either<RegexQuery, VersionQuery>> postqueries, CombinatorType combinatorType) {
            switch (WhenMappings.$EnumSwitchMapping$1[postquery.getQueryMode().ordinal()]) {
                case 1: {
                    RegexQuery regexQuery = new RegexQuery(postquery.getLeft(), new Regex(postquery.getRight()), combinatorType);
                    postqueries.add(Either.Companion.Left(regexQuery));
                    break;
                }
                case 2: {
                    VersionQuery versionQuery = new VersionQuery(postquery.getLeft(), postquery.getComparison().toString(), postquery.getRight(), combinatorType);
                    postqueries.add(Either.Companion.Right(versionQuery));
                    break;
                }
                default: {
                    throw new InsightIllegalException("Illegal query mode inside postqueries");
                }
            }
        }

        private final Query queryWithoutThen(List<Either<QueryExpression, QueryCombinator>> allQueries, List<Either<RegexQuery, VersionQuery>> postQueries) {
            boolean bl;
            block12: {
                boolean isPostQueriesValid;
                Either it;
                int $i$f$all;
                Object $this$all$iv;
                block11: {
                    boolean bl2;
                    $this$all$iv = allQueries;
                    $i$f$all = 0;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            it = (Either)element$iv;
                            boolean bl3 = false;
                            if (!it.isLeft() || Companion.isValidPostqueryMode(it)) continue;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = isPostQueriesValid = true;
                    }
                }
                if (isPostQueriesValid) {
                    $this$all$iv = allQueries.iterator();
                    $i$f$all = 0;
                    while ($this$all$iv.hasNext()) {
                        CombinatorType combinatorType;
                        int index = $i$f$all++;
                        Either value = (Either)$this$all$iv.next();
                        if (!value.isLeft()) continue;
                        Object a = value.getLeftOrNull();
                        Intrinsics.checkNotNull(a);
                        QueryExpression postquery = (QueryExpression)a;
                        if (index == 0) {
                            combinatorType = null;
                        } else {
                            QueryCombinator queryCombinator = allQueries.get(index - 1).getRightOrNull();
                            Intrinsics.checkNotNull((Object)queryCombinator);
                            combinatorType = queryCombinator.getType();
                        }
                        this.addToPostQueries(postquery, postQueries, combinatorType);
                    }
                    return new Query(CollectionsKt.emptyList(), postQueries, null);
                }
                Iterable $this$any$iv = allQueries;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Either)element$iv;
                        boolean bl4 = false;
                        QueryExpression queryExpression = (QueryExpression)it.getLeftOrNull();
                        if (!((queryExpression != null ? queryExpression.getQueryMode() : null) == QueryMode.RegexMode)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new InsightIllegalException("SQL Queries should not contains RegexMode conditions");
            }
            return new Query(allQueries, postQueries, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isValidPostqueryMode(Either<QueryExpression, QueryCombinator> it) {
            QueryExpression queryExpression = it.getLeftOrNull();
            if ((queryExpression != null ? queryExpression.getQueryMode() : null) == QueryMode.RegexMode) return true;
            QueryExpression queryExpression2 = it.getLeftOrNull();
            if ((queryExpression2 != null ? queryExpression2.getQueryMode() : null) != QueryMode.SemverMode) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[TokenType.values().length];
                nArray[TokenType.Combinator.ordinal()] = 1;
                nArray[TokenType.Identifier.ordinal()] = 2;
                nArray[TokenType.ComparisonKind.ordinal()] = 3;
                nArray[TokenType.StringKind.ordinal()] = 4;
                nArray[TokenType.RegexKind.ordinal()] = 5;
                nArray[TokenType.LikeKind.ordinal()] = 6;
                nArray[TokenType.VersionKind.ordinal()] = 7;
                nArray[TokenType.Unknown.ordinal()] = 8;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[QueryMode.values().length];
                nArray[QueryMode.RegexMode.ordinal()] = 1;
                nArray[QueryMode.SemverMode.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[QueryMode.values().length];
            nArray[QueryMode.StrictMode.ordinal()] = 1;
            nArray[QueryMode.LikeMode.ordinal()] = 2;
            nArray[QueryMode.RegexMode.ordinal()] = 3;
            nArray[QueryMode.SemverMode.ordinal()] = 4;
            nArray[QueryMode.Invalid.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CombinatorType.values().length];
            nArray[CombinatorType.And.ordinal()] = 1;
            nArray[CombinatorType.Or.ordinal()] = 2;
            nArray[CombinatorType.Then.ordinal()] = 3;
            nArray[CombinatorType.NotSupported.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

