/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.domain.version;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.domain.comparison.Comparison;
import org.archguard.domain.version.VersionNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0003`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/archguard/domain/version/VersionComparison;", "", "versionNo", "Lorg/archguard/domain/version/VersionNumber;", "symbol", "", "(Lorg/archguard/domain/version/VersionNumber;Ljava/lang/String;)V", "cachedVersion", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "comparison", "Lorg/archguard/domain/comparison/Comparison;", "compareByResult", "", "result", "", "comp", "eval", "left", "right", "parseVersion", "other", "toOther", "domain"})
public final class VersionComparison {
    @NotNull
    private final VersionNumber versionNo;
    @NotNull
    private HashMap<String, VersionNumber> cachedVersion;
    @NotNull
    private final Comparison comparison;

    public VersionComparison(@NotNull VersionNumber versionNo, @NotNull String symbol) {
        Intrinsics.checkNotNullParameter((Object)versionNo, (String)"versionNo");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.versionNo = versionNo;
        this.cachedVersion = new HashMap();
        this.comparison = Comparison.Companion.fromString(symbol);
    }

    public /* synthetic */ VersionComparison(VersionNumber versionNumber, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            versionNumber = new VersionNumber(0, 0, 0, 0, null);
        }
        if ((n & 2) != 0) {
            string = "";
        }
        this(versionNumber, string);
    }

    public final boolean eval(@NotNull String left, @NotNull String symbol, @NotNull String right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Comparison comparison = Comparison.Companion.fromString(symbol);
        if (comparison == Comparison.NotSupport) {
            return false;
        }
        return this.eval(left, comparison, right);
    }

    public final boolean eval(@NotNull String left, @NotNull Comparison comparison, @NotNull String right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)((Object)comparison), (String)"comparison");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        VersionNumber versionNumber = this.parseVersion(left);
        if (versionNumber == null) {
            return false;
        }
        VersionNumber leftVersion = versionNumber;
        VersionNumber versionNumber2 = this.parseVersion(right);
        if (versionNumber2 == null) {
            return false;
        }
        VersionNumber rightVersion = versionNumber2;
        int result = leftVersion.compareTo(rightVersion);
        return this.compareByResult(result, comparison);
    }

    public final boolean toOther(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.comparison == Comparison.NotSupport) {
            return false;
        }
        VersionNumber versionNumber = this.parseVersion(other);
        if (versionNumber == null) {
            return false;
        }
        VersionNumber otherVersion = versionNumber;
        int result = this.versionNo.compareTo(otherVersion);
        return this.compareByResult(result, this.comparison);
    }

    private final VersionNumber parseVersion(String other) {
        if (((Map)this.cachedVersion).containsKey(other)) {
            return this.cachedVersion.get(other);
        }
        VersionNumber versionNumber = VersionNumber.Companion.parse(other);
        if (versionNumber != null) {
            ((Map)this.cachedVersion).put(other, versionNumber);
        }
        return versionNumber;
    }

    private final boolean compareByResult(int result, Comparison comp) {
        if (result == 0 && comp == Comparison.Equal) {
            return true;
        }
        if (result != 0 && comp == Comparison.NotEqual) {
            return true;
        }
        if (result > 0 && comp == Comparison.GreaterThan) {
            return true;
        }
        if (result < 0 && comp == Comparison.LessThan) {
            return true;
        }
        if (result >= 0 && comp == Comparison.GreaterThanOrEqual) {
            return true;
        }
        return result <= 0 && comp == Comparison.LessThanOrEqual;
    }

    public VersionComparison() {
        this(null, null, 3, null);
    }
}

