/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.domain.version;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.domain.version.VersionCompareKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/archguard/domain/version/VersionComparisonParser;", "", "text", "", "(Ljava/lang/String;)V", "length", "", "pos", "isSymbolInNEXT", "", "startWithComparison", "symbol", "version", "domain"})
public final class VersionComparisonParser {
    @NotNull
    private final String text;
    private final int length;
    private int pos;

    public VersionComparisonParser(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.length = this.text.length();
    }

    public final boolean startWithComparison() {
        return VersionCompareKt.getComparisonSymbol().contains(String.valueOf(this.text.charAt(this.pos)));
    }

    private final boolean isSymbolInNEXT() {
        return this.pos < this.length && VersionCompareKt.getComparisonSymbol().contains(String.valueOf(this.text.charAt(this.pos)));
    }

    @NotNull
    public final String symbol() {
        int start = this.pos;
        while (this.isSymbolInNEXT()) {
            int n = this.pos;
            this.pos = n + 1;
        }
        String string = this.text.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @NotNull
    public final String version() {
        String string = this.text.substring(this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }
}

