/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.domain.version;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.domain.version.VersionParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/archguard/domain/version/VersionNumber;", "", "major", "", "minor", "micro", "patch", "qualifier", "", "(IIIILjava/lang/String;)V", "getMajor", "()I", "getMicro", "getMinor", "getPatch", "getQualifier", "()Ljava/lang/String;", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "hashCode", "toString", "Companion", "domain"})
public final class VersionNumber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int micro;
    private final int patch;
    @Nullable
    private final String qualifier;

    public VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getQualifier() {
        return this.qualifier;
    }

    public final int compareTo(@NotNull VersionNumber other) {
        String string;
        String string2;
        String string3;
        String string4;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        if (this.patch != other.patch) {
            return this.patch - other.patch;
        }
        String string5 = this.qualifier;
        if (string5 != null) {
            String string6 = string5.toLowerCase(Locale.ROOT);
            string4 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string4 = string3 = null;
        }
        if (string4 == null) {
            string3 = "";
        }
        String string7 = other.qualifier;
        if (string7 != null) {
            String string8 = string7.toLowerCase(Locale.ROOT);
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string3.compareTo(string);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionNumber)) {
            return false;
        }
        if (this.major != ((VersionNumber)other).major) {
            return false;
        }
        if (this.minor != ((VersionNumber)other).minor) {
            return false;
        }
        if (this.micro != ((VersionNumber)other).micro) {
            return false;
        }
        if (this.patch != ((VersionNumber)other).patch) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.qualifier, (Object)((VersionNumber)other).qualifier);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.patch;
        String string = this.qualifier;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.micro;
    }

    public final int component4() {
        return this.patch;
    }

    @Nullable
    public final String component5() {
        return this.qualifier;
    }

    @NotNull
    public final VersionNumber copy(int major, int minor, int micro, int patch, @Nullable String qualifier) {
        return new VersionNumber(major, minor, micro, patch, qualifier);
    }

    public static /* synthetic */ VersionNumber copy$default(VersionNumber versionNumber, int n, int n2, int n3, int n4, String string, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = versionNumber.major;
        }
        if ((n5 & 2) != 0) {
            n2 = versionNumber.minor;
        }
        if ((n5 & 4) != 0) {
            n3 = versionNumber.micro;
        }
        if ((n5 & 8) != 0) {
            n4 = versionNumber.patch;
        }
        if ((n5 & 0x10) != 0) {
            string = versionNumber.qualifier;
        }
        return versionNumber.copy(n, n2, n3, n4, string);
    }

    @NotNull
    public String toString() {
        return "VersionNumber(major=" + this.major + ", minor=" + this.minor + ", micro=" + this.micro + ", patch=" + this.patch + ", qualifier=" + this.qualifier + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/archguard/domain/version/VersionNumber$Companion;", "", "()V", "parse", "Lorg/archguard/domain/version/VersionNumber;", "version", "", "domain"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VersionNumber parse(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            if (((CharSequence)version).length() == 0) {
                return null;
            }
            VersionParser parser = new VersionParser(version);
            if (!parser.startWithDigit()) {
                return null;
            }
            int major = 0;
            int minor = 0;
            int micro = 0;
            int patch = 0;
            major = parser.digit();
            if (parser.isDotInNext()) {
                parser.nextChar();
                minor = parser.digit();
                if (parser.isDotInNext()) {
                    parser.nextChar();
                    micro = parser.digit();
                    if (parser.isSeparatorInNext()) {
                        parser.nextChar();
                        patch = parser.digit();
                    }
                }
            }
            return new VersionNumber(major, minor, micro, patch, parser.qualifier());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

