/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.domain.version;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/archguard/domain/version/VersionParser;", "", "versionStr", "", "(Ljava/lang/String;)V", "dot", "", "length", "", "pos", "digit", "isDigitInNext", "", "isDotInNext", "isSeparatorInNext", "nextChar", "", "qualifier", "startWithDigit", "domain"})
public final class VersionParser {
    @NotNull
    private final String versionStr;
    private final char dot;
    private final int length;
    private int pos;

    public VersionParser(@NotNull String versionStr) {
        Intrinsics.checkNotNullParameter((Object)versionStr, (String)"versionStr");
        this.versionStr = versionStr;
        this.dot = (char)46;
        this.length = this.versionStr.length();
    }

    private final boolean isDigitInNext() {
        return this.pos < this.length && Character.isDigit(this.versionStr.charAt(this.pos));
    }

    public final boolean startWithDigit() {
        return Character.isDigit(this.versionStr.charAt(0));
    }

    public final int digit() {
        int start = this.pos;
        while (this.isDigitInNext()) {
            int n = this.pos;
            this.pos = n + 1;
        }
        String string = this.versionStr.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String substring = string;
        try {
            return Integer.parseInt(substring);
        }
        catch (Exception e) {
            int n = this.pos = start;
            this.pos = n + -1;
            return 0;
        }
    }

    public final boolean isDotInNext() {
        if (this.pos >= this.length - 1) {
            return false;
        }
        if (this.versionStr.charAt(this.pos) == this.dot) {
            return Character.isDigit(this.versionStr.charAt(this.pos + 1));
        }
        return false;
    }

    public final void nextChar() {
        int n = this.pos;
        this.pos = n + 1;
    }

    public final boolean isSeparatorInNext() {
        if (this.pos >= this.length - 1) {
            return false;
        }
        if (this.versionStr.charAt(this.pos) == this.dot || this.versionStr.charAt(this.pos) == '_') {
            return Character.isDigit(this.versionStr.charAt(this.pos + 1));
        }
        return false;
    }

    @Nullable
    public final String qualifier() {
        if (this.pos == this.length) {
            return null;
        }
        if (this.versionStr.charAt(this.pos) == this.dot || this.versionStr.charAt(this.pos) == '-') {
            this.nextChar();
            String string = this.versionStr.substring(this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return string;
        }
        return null;
    }
}

