/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.aaac.repl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.aaac.api.InterpreterRequest;
import org.archguard.aaac.api.InterpreterService;
import org.archguard.aaac.api.messaging.ErrorContent;
import org.archguard.aaac.api.messaging.Message;
import org.archguard.aaac.api.messaging.MessageType;
import org.archguard.aaac.repl.compiler.KotlinReplWrapper;
import org.archguard.dsl.base.model.ReactiveAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.repl.EvalResultEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/archguard/aaac/repl/ArchdocInterpreter;", "Lorg/archguard/aaac/api/InterpreterService;", "()V", "compiler", "Lorg/archguard/aaac/repl/compiler/KotlinReplWrapper;", "logger", "Lorg/slf4j/Logger;", "convertResult", "Lorg/archguard/aaac/api/messaging/Message;", "result", "Lorg/jetbrains/kotlinx/jupyter/repl/EvalResultEx;", "id", "", "eval", "interpreterRequest", "Lorg/archguard/aaac/api/InterpreterRequest;", "repl-api"})
public final class ArchdocInterpreter
implements InterpreterService {
    @NotNull
    private KotlinReplWrapper compiler = new KotlinReplWrapper();
    @NotNull
    private final Logger logger;

    public ArchdocInterpreter() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this.javaClass)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public Message eval(@NotNull InterpreterRequest interpreterRequest) {
        Intrinsics.checkNotNullParameter((Object)interpreterRequest, (String)"interpreterRequest");
        try {
            EvalResultEx result = KotlinReplWrapper.eval$default(this.compiler, interpreterRequest.getCode(), interpreterRequest.getId(), false, 4, null);
            return this.convertResult(result, interpreterRequest.getId());
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            String string = e.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.javaClass.name");
            ErrorContent content = new ErrorContent(string, e.toString());
            return new Message(interpreterRequest.getId(), "", "", MessageType.ERROR, content, null, 32, null);
        }
    }

    private final Message convertResult(EvalResultEx result, int id) {
        String string;
        Class<?> resultValue = result.getRawValue();
        Class<?> clazz = resultValue;
        if ((clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : (string = null)) == null) {
            string = "";
        }
        String className = string;
        Message message = new Message(id, String.valueOf(resultValue), className, null, null, null, 56, null);
        if (resultValue instanceof ReactiveAction) {
            message.setAction((ReactiveAction)resultValue);
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.archguard.dsl.design", (boolean)false, (int)2, null)) {
            message.setMsgType(MessageType.ARCHGUARD_GRAPH);
        }
        return message;
    }
}

