package org.archguard.comate.dynamic

import org.archguard.comate.command.ComateContext
import org.archguard.comate.dynamic.functions.ComateFunction
import org.archguard.comate.dynamic.functions.DyFunction
import org.archguard.comate.dynamic.functions.toSnakeCase
import org.reflections.Reflections

fun findClasses(): List<Class<out DyFunction>> {
    val packageName = DyFunction::class.java.`package`.name
    val reflections = Reflections(packageName)

    val annotated: Set<Class<out DyFunction>> =
        reflections.getTypesAnnotatedWith(ComateFunction::class.java) as Set<Class<out DyFunction>>

    return annotated.toList()
}


class DynamicContextFactory(val context: ComateContext) {
    private var classMap: Map<String, DyFunction> = mapOf()

    init {
        classMap = findClasses().associate { clazz ->
            val defaultConstructor = clazz.declaredConstructors[0]
            val dyFunction = defaultConstructor.newInstance(context) as DyFunction
            clazz.name.toSnakeCase() to dyFunction
        }
    }

    fun functions(): List<String> {
        return this.classMap.map {
            it.value.define()
        }
    }

    fun tools(): Map<String, String> {
        return this.classMap.map {
            it.key to it.value.define()
        }.toMap()
    }

    fun findByName(name: String): DyFunction? {
        return this.classMap[name]
    }
}
